<?php
// Establecer zona horaria
date_default_timezone_set('America/Caracas');

// ⚠️ CRÍTICO: VERIFICAR SI LA SESIÓN YA ESTÁ ACTIVA ANTES DE CONFIGURAR
if (session_status() === PHP_SESSION_NONE) {
    // Solo configurar sesión si NO está activa
    $tiempo_sesion_segundos = 3600; // 1 hora de inactividad
    ini_set('session.gc_maxlifetime', $tiempo_sesion_segundos);
    ini_set('session.cookie_lifetime', 0); // 0 = expira cuando se cierra navegador
    
    // Configuración de seguridad de sesión
    ini_set('session.cookie_httponly', 1);
    ini_set('session.use_only_cookies', 1);
    ini_set('session.cookie_samesite', 'Strict');
    // ✅ PRODUCCIÓN: Cookie segura activada para HTTPS
    ini_set('session.cookie_secure', 1);
    
    // AHORA SÍ: Iniciar sesión después de toda la configuración
    session_start();
} else {
    // Si la sesión ya está activa, solo aseguramos que las variables críticas existan
    if (!isset($_SESSION['last_activity'])) {
        $_SESSION['last_activity'] = time();
    }
}

// Carga el autoloader de Composer
require_once __DIR__ . '/../vendor/autoload.php';

// Carga las variables de entorno desde el archivo .env
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__ . '/..');
$dotenv->load();

// Carga la conexión a la base de datos
require_once __DIR__ . '/db.php';
?>