<?php
define('IS_AJAX', true);
require_once '../administracion/includes/seguridad.php';

header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'Acción no válida.'];
$usuario_id = $_SESSION['user_id'] ?? 0;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        $response['message'] = 'Error de seguridad (CSRF).';
        echo json_encode($response);
        exit();
    }
}

$action = $_POST['action'] ?? $_GET['action'] ?? '';

switch ($action) {
    case 'cargar_dashboard_supervisor':
        if (!puede('ver_dashboard_supervisor') && !puede('supervisar_todos_operadores')) {
            $response['message'] = 'Acceso denegado.';
            break;
        }

        try {
            $equipo_ids = [];
            
            if (puede('supervisar_todos_operadores')) {
                $stmt_equipo = $conn->query("SELECT u.id FROM usuarios u JOIN roles r ON u.rol_id = r.id WHERE r.clave = 'operador' AND u.estado = 1");
                $equipo_ids = $stmt_equipo->fetchAll(PDO::FETCH_COLUMN);
            } else {
                $stmt_equipo = $conn->prepare("SELECT operador_id FROM equipo_supervisor WHERE supervisor_id = ?");
                $stmt_equipo->execute([$usuario_id]);
                $equipo_ids = $stmt_equipo->fetchAll(PDO::FETCH_COLUMN);
            }

            $dashboard_data = [
                'total_prospectos' => 0, 'prospectos_nuevos' => 0, 'prospectos_gestionados_hoy' => 0,
                'actividad_reciente' => [], 'rendimiento_equipo' => []
            ];

            if (!empty($equipo_ids)) {
                $placeholders = implode(',', array_fill(0, count($equipo_ids), '?'));
                
                $stmt_stats = $conn->prepare("SELECT COUNT(*) as total, SUM(CASE WHEN estado = 'nuevo' THEN 1 ELSE 0 END) as nuevos, SUM(CASE WHEN DATE(fecha_ultima_llamada) = CURDATE() THEN 1 ELSE 0 END) as gestionados_hoy FROM prospectos WHERE operador_id IN ($placeholders)");
                $stmt_stats->execute($equipo_ids);
                $stats = $stmt_stats->fetch(PDO::FETCH_ASSOC);

                $dashboard_data['total_prospectos'] = (int)($stats['total'] ?? 0);
                $dashboard_data['prospectos_nuevos'] = (int)($stats['nuevos'] ?? 0);
                $dashboard_data['prospectos_gestionados_hoy'] = (int)($stats['gestionados_hoy'] ?? 0);

                $stmt_actividad = $conn->prepare("SELECT p.nombre, p.estado, p.ultima_accion, p.fecha_ultima_llamada, u.nombre as operador_nombre FROM prospectos p JOIN usuarios u ON p.operador_id = u.id WHERE p.operador_id IN ($placeholders) AND p.fecha_ultima_llamada IS NOT NULL ORDER BY p.fecha_ultima_llamada DESC LIMIT 6");
                $stmt_actividad->execute($equipo_ids);
                $dashboard_data['actividad_reciente'] = $stmt_actividad->fetchAll(PDO::FETCH_ASSOC);

                $stmt_rendimiento = $conn->prepare("SELECT u.id, u.nombre as operador_nombre, u.foto_perfil, COUNT(p.id) as total_asignados, SUM(CASE WHEN p.estado <> 'nuevo' THEN 1 ELSE 0 END) as gestionados, SUM(CASE WHEN DATE(p.fecha_ultima_llamada) = CURDATE() THEN 1 ELSE 0 END) as gestionados_hoy_operador FROM usuarios u LEFT JOIN prospectos p ON u.id = p.operador_id WHERE u.id IN ($placeholders) GROUP BY u.id, u.nombre, u.foto_perfil ORDER BY gestionados_hoy_operador DESC, u.nombre ASC");
                $stmt_rendimiento->execute($equipo_ids);
                $dashboard_data['rendimiento_equipo'] = $stmt_rendimiento->fetchAll(PDO::FETCH_ASSOC);
            }

            // --- INICIO: CÓDIGO INSERTADO PARA RENDIMIENTO POR JORNADA ---
            $es_monitor_global = puede('supervisar_todos_operadores');
            $sql_jornadas = $es_monitor_global ?
                "SELECT j.ciudad_nombre, COUNT(jc.id) as agendados
                 FROM jornadas j
                 JOIN jornada_clientes jc ON j.id = jc.jornada_id
                 JOIN rutas r ON j.ruta_id = r.id
                 WHERE r.archivada = 0
                 GROUP BY j.ciudad_nombre
                 ORDER BY j.ciudad_nombre" :
                "SELECT j.ciudad_nombre, COUNT(jc.id) as agendados
                 FROM jornadas j
                 JOIN jornada_clientes jc ON j.id = jc.jornada_id
                 JOIN equipo_supervisor es ON jc.agendado_por_operador_id = es.operador_id
                 JOIN rutas r ON j.ruta_id = r.id
                 WHERE es.supervisor_id = :supervisor_id AND r.archivada = 0
                 GROUP BY j.ciudad_nombre
                 ORDER BY j.ciudad_nombre";
            
            $stmt_jornadas = $conn->prepare($sql_jornadas);
            if (!$es_monitor_global) {
                $stmt_jornadas->execute(['supervisor_id' => $usuario_id]);
            } else {
                $stmt_jornadas->execute();
            }
            $dashboard_data['rendimiento_jornadas'] = $stmt_jornadas->fetchAll(PDO::FETCH_ASSOC);
            // --- FIN: CÓDIGO INSERTADO PARA RENDIMIENTO POR JORNADA ---

            $response = ['success' => true, 'data' => $dashboard_data];

        } catch (Exception $e) {
            error_log("Error en cargar_dashboard_supervisor: " . $e->getMessage());
            // ESTA LÍNEA ES LA MODIFICACIÓN PARA DEBUGGING
            $response['message'] = 'Error al cargar los datos del dashboard: ' . $e->getMessage();
        }
        break;

    case 'cargar_actividad_completa_equipo':
        if (!puede('ver_dashboard_supervisor') && !puede('supervisar_todos_operadores')) {
            $response['message'] = 'Acceso denegado.';
            break;
        }

        try {
            $equipo_ids = [];
            if (puede('supervisar_todos_operadores')) {
                $stmt_equipo = $conn->query("SELECT u.id FROM usuarios u JOIN roles r ON u.rol_id = r.id WHERE r.clave = 'operador' AND u.estado = 1");
                $equipo_ids = $stmt_equipo->fetchAll(PDO::FETCH_COLUMN);
            } else {
                $stmt_equipo = $conn->prepare("SELECT operador_id FROM equipo_supervisor WHERE supervisor_id = ?");
                $stmt_equipo->execute([$usuario_id]);
                $equipo_ids = $stmt_equipo->fetchAll(PDO::FETCH_COLUMN);
            }

            if (empty($equipo_ids)) {
                $response = ['success' => true, 'data' => [], 'pagination' => ['total_records' => 0, 'total_pages' => 0, 'current_page' => 1]];
                break;
            }

            $placeholders = implode(',', array_fill(0, count($equipo_ids), '?'));
            $params = $equipo_ids;
            
            $sql_base = "FROM prospectos p JOIN usuarios u ON p.operador_id = u.id WHERE p.operador_id IN ($placeholders)";
            
            if (!empty($_GET['search'])) {
                $search_term = '%' . $_GET['search'] . '%';
                $sql_base .= " AND (p.nombre LIKE ? OR p.estado LIKE ? OR u.nombre LIKE ?)";
                array_push($params, $search_term, $search_term, $search_term);
            }

            $stmt_count = $conn->prepare("SELECT COUNT(*) " . $sql_base);
            $stmt_count->execute($params);
            $total_records = $stmt_count->fetchColumn();
            
            $records_per_page = 15;
            $total_pages = ceil($total_records / $records_per_page);
            $current_page = filter_input(INPUT_GET, 'page', FILTER_VALIDATE_INT, ['options' => ['default' => 1, 'min_range' => 1]]);
            $offset = ($current_page - 1) * $records_per_page;
            
            $sql_data = "SELECT p.id, p.nombre, p.telefono, p.estado, IFNULL(p.ultima_accion, 'Sin Gestionar') as ultima_accion, COALESCE(p.fecha_ultima_llamada, p.fecha_creacion) as fecha_evento, u.nombre as operador_nombre FROM prospectos p JOIN usuarios u ON p.operador_id = u.id WHERE p.operador_id IN ($placeholders) ORDER BY fecha_evento DESC LIMIT $records_per_page OFFSET $offset";
            
            $stmt_data = $conn->prepare($sql_data);
            $stmt_data->execute($params);
            $actividad = $stmt_data->fetchAll(PDO::FETCH_ASSOC);

            foreach ($actividad as &$act) {
                $act['fecha_ultima_llamada'] = $act['fecha_evento'];
                unset($act['fecha_evento']);
            }

            $response = [
                'success' => true, 'data' => $actividad,
                'pagination' => ['total_records' => (int)$total_records, 'total_pages' => (int)$total_pages, 'current_page' => (int)$current_page]
            ];

        } catch (Exception $e) {
            $response['message'] = 'Error al cargar la actividad detallada del equipo.';
            error_log('Error en cargar_actividad_completa_equipo: ' . $e->getMessage());
        }
        break;

    case 'cargar_prospectos_asesor':
        $asesor_id = filter_input(INPUT_GET, 'asesor_id', FILTER_VALIDATE_INT);
        if (!$asesor_id) { $response['message'] = 'ID de asesor no válido.'; break; }

        // --- VERIFICACIÓN DE SEGURIDAD ---
        if (!puede('supervisar_todos_operadores')) {
            $stmt_check = $conn->prepare("SELECT COUNT(*) FROM equipo_supervisor WHERE supervisor_id = ? AND operador_id = ?");
            $stmt_check->execute([$usuario_id, $asesor_id]);
            if ($stmt_check->fetchColumn() == 0) {
                $response['message'] = 'No tienes permiso para supervisar a este asesor.';
                echo json_encode($response);
                exit();
            }
        }

        try {
            $params = ['operador_id' => $asesor_id];
            $sql_base = "FROM prospectos WHERE operador_id = :operador_id";

            if (!empty($_GET['campana'])) { $sql_base .= " AND campana = :campana"; $params['campana'] = $_GET['campana']; }
            if (!empty($_GET['fecha_inicio'])) { $sql_base .= " AND DATE(fecha_creacion) >= :fecha_inicio"; $params['fecha_inicio'] = $_GET['fecha_inicio']; }
            if (!empty($_GET['fecha_fin'])) { $sql_base .= " AND DATE(fecha_creacion) <= :fecha_fin"; $params['fecha_fin'] = $_GET['fecha_fin']; }

            $stmt_count = $conn->prepare("SELECT COUNT(*) " . $sql_base);
            $stmt_count->execute($params);
            $total_records = $stmt_count->fetchColumn();

            $records_per_page = 50;
            $total_pages = $total_records > 0 ? ceil($total_records / $records_per_page) : 0;
            $current_page = filter_input(INPUT_GET, 'page', FILTER_VALIDATE_INT, ['options' => ['default' => 1, 'min_range' => 1]]);
            if ($current_page > $total_pages) { $current_page = $total_pages > 0 ? $total_pages : 1; }
            $offset = ($current_page - 1) * $records_per_page;

            // ÚNICA LÍNEA MODIFICADA: SE AÑADIÓ EL CAMPO 'notas' A LA CONSULTA
            $sql_data = "SELECT id, nombre, telefono, ciudad, campana, estado, ultima_accion, fecha_creacion, notas " . $sql_base . " ORDER BY fecha_creacion DESC LIMIT :limit OFFSET :offset";
            
            $stmt_data = $conn->prepare($sql_data);
            
            foreach ($params as $key => &$val) { $stmt_data->bindParam(':' . $key, $val); }
            $stmt_data->bindValue(':limit', $records_per_page, PDO::PARAM_INT);
            $stmt_data->bindValue(':offset', $offset, PDO::PARAM_INT);
            $stmt_data->execute();
            $prospectos = $stmt_data->fetchAll(PDO::FETCH_ASSOC);

            $response = [
                'success' => true, 'data' => $prospectos,
                'pagination' => ['total_records' => (int)$total_records, 'total_pages' => (int)$total_pages, 'current_page' => (int)$current_page]
            ];
        } catch (PDOException $e) {
            $response['message'] = 'Error al cargar los prospectos del asesor.';
        }
        break;

    default:
        $response['message'] = 'Acción de supervisor desconocida.';
        break;
}

echo json_encode($response);