<?php
require_once '../administracion/includes/seguridad.php';

header('Content-Type: application/json');
header('Cache-Control: no-cache');

$response = ['success' => false, 'message' => 'Acción no válida.'];

if (!puede('monitorear_sesiones')) {
    $response['message'] = 'Acceso denegado.';
    echo json_encode($response);
    exit();
}

$action = $_GET['action'] ?? '';

if ($action === 'obtener_resumen') {
    try {
        // Query optimizada - solo lo esencial
        $stmt = $conn->prepare("
            SELECT 
                u.id, 
                u.nombre, 
                r.nombre as rol_nombre, 
                COUNT(s.session_id) as sesiones_activas,
                UNIX_TIMESTAMP(MAX(s.last_activity)) as ultima_actividad_ts
            FROM sesiones_activas s
            JOIN usuarios u ON s.usuario_id = u.id
            LEFT JOIN roles r ON u.rol_id = r.id
            WHERE s.estado = 'activa' AND s.last_activity > NOW() - INTERVAL 30 MINUTE
            GROUP BY u.id, u.nombre, r.nombre
            ORDER BY u.nombre ASC
        ");
        
        $stmt->execute();
        $usuarios = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Crear hash para detectar cambios del lado del cliente
        $hash = md5(serialize($usuarios));
        
        // Solo verificar si el cliente envió un hash para comparar
        $client_hash = $_GET['hash'] ?? '';
        
        if ($client_hash === $hash) {
            // No hay cambios
            $response = [
                'success' => true,
                'changed' => false,
                'hash' => $hash,
                'timestamp' => date('H:i:s')
            ];
        } else {
            // Hay cambios, enviar datos
            $response = [
                'success' => true,
                'changed' => true,
                'data' => $usuarios,
                'hash' => $hash,
                'timestamp' => date('H:i:s')
            ];
        }
        
    } catch (PDOException $e) {
        error_log("Error en polling sesiones: " . $e->getMessage());
        $response = [
            'success' => false,
            'message' => 'Error interno'
        ];
    }
}

echo json_encode($response);