<?php
define('IS_AJAX', true);
date_default_timezone_set('America/Caracas');

require_once '../administracion/includes/seguridad.php'; // Ajusta la ruta si es necesario

header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'Acción no válida o error desconocido.'];
$usuario_id = $_SESSION['user_id'] ?? 0;
$action = $_GET['action'] ?? '';

// OBTENER ROL Y SEDES PERMITIDAS DEL USUARIO LOGUEADO
try {
    $stmt_usuario = $conn->prepare("SELECT rol_id FROM usuarios WHERE id = ?");
    $stmt_usuario->execute([$usuario_id]);
    $rol_id_usuario = $stmt_usuario->fetchColumn();
    $es_superadmin = ($rol_id_usuario == 1);

    $sedes_permitidas = [];
    if (!$es_superadmin) {
        $stmt_sedes = $conn->prepare("SELECT sede_id FROM usuario_sede WHERE usuario_id = ?");
        $stmt_sedes->execute([$usuario_id]);
        $sedes_permitidas = $stmt_sedes->fetchAll(PDO::FETCH_COLUMN);
    }
} catch (PDOException $e) {
    $response['message'] = 'Error crítico al verificar permisos de sede: ' . $e->getMessage();
    echo json_encode($response);
    exit();
}

if ($action === 'cargar_historial') {
    if (!puede('ver_afiliaciones')) {
        $response['message'] = 'Acceso denegado para ver el historial de pagos.';
        echo json_encode($response);
        exit();
    }

    $afiliacion_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
    if (!$afiliacion_id) {
        $response['message'] = 'ID de afiliación no válido.';
        echo json_encode($response);
        exit();
    }

    try {
        // 1. Obtener datos del titular y validar acceso por sede
        $sql_titular = "SELECT id, nombre_titular, apellido_titular, nombre_empresa, tipo_contrato, sede_id FROM afiliaciones WHERE id = ?";
        $stmt_titular = $conn->prepare($sql_titular);
        $stmt_titular->execute([$afiliacion_id]);
        $afiliacion = $stmt_titular->fetch(PDO::FETCH_ASSOC);

        if (!$afiliacion) {
            throw new Exception("Afiliación no encontrada.");
        }

        if (!$es_superadmin && !in_array($afiliacion['sede_id'], $sedes_permitidas)) {
            throw new Exception("No tiene permisos para ver el historial de esta afiliación.");
        }

        // 2. Obtener el historial de pagos
        $sql_historial = "SELECT 
                            hp.id,
                            hp.monto_pagado,
                            hp.monto_bs,
                            hp.fecha_pago,
                            hp.periodo_cubierto_desde,
                            hp.periodo_cubierto_hasta,
                            hp.metodo_pago,
                            hp.referencia,
                            hp.fecha_registro,
                            p.nombre as nombre_plan,
                            u.nombre as nombre_usuario_registro
                          FROM historial_pagos hp
                          LEFT JOIN planes p ON hp.plan_id = p.id
                          LEFT JOIN usuarios u ON hp.usuario_id = u.id
                          WHERE hp.afiliacion_id = ?
                          ORDER BY hp.fecha_pago DESC, hp.id DESC";

        $stmt_historial = $conn->prepare($sql_historial);
        $stmt_historial->execute([$afiliacion_id]);
        $historial = $stmt_historial->fetchAll(PDO::FETCH_ASSOC);

        $response = [
            'success' => true,
            'data' => [
                'afiliacion' => $afiliacion,
                'historial' => $historial
            ]
        ];

    } catch (Exception $e) {
        $response['message'] = 'Error al cargar el historial: ' . $e->getMessage();
    }
}

echo json_encode($response);
?>