<?php
define('IS_AJAX', true);
require_once '../administracion/includes/seguridad.php';

header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'Acción no válida o sin permisos.'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        $response['message'] = 'Error de seguridad (CSRF).';
        echo json_encode($response);
        exit();
    }
}

$action = $_POST['action'] ?? $_GET['action'] ?? '';

switch ($action) {
    case 'cargar_configuraciones':
        if (!puede('gestionar_nomina')) break;

        try {
            $stmt = $conn->prepare("
                SELECT 
                    u.id as usuario_id, u.nombre, u.cedula,
                    nc.cesta_ticket,
                    nc.complemento_cesta_ticket,
                    nc.bono_transporte,
                    nc.complemento_productividad
                FROM usuarios u
                LEFT JOIN nomina_configuracion nc ON u.id = nc.usuario_id
                WHERE u.estado = 1 AND u.rol_id != 99999999999999
                ORDER BY u.nombre ASC
            ");
            $stmt->execute();
            $empleados = $stmt->fetchAll(PDO::FETCH_ASSOC);
            $response = ['success' => true, 'data' => $empleados];
        } catch (PDOException $e) {
            error_log(" nomina_configuracion_ajax (cargar): " . $e->getMessage());
            $response['message'] = 'Error al cargar las configuraciones de los empleados.';
        }
        break;

    case 'guardar_configuracion':
        if (!puede('gestionar_nomina')) break;

        $usuario_id = filter_input(INPUT_POST, 'usuario_id', FILTER_VALIDATE_INT);
        if (!$usuario_id) {
            $response['message'] = 'ID de empleado no válido.';
            break;
        }

        // Usar floatval para asegurar que los datos sean numéricos
        $cesta_ticket = floatval($_POST['cesta_ticket'] ?? 40.00);
        $comp_cesta_ticket = floatval($_POST['complemento_cesta_ticket'] ?? 30.00);
        $bono_transporte = floatval($_POST['bono_transporte'] ?? 40.00);
        $comp_productividad = floatval($_POST['complemento_productividad'] ?? 0.00);

        try {
            // "INSERT ... ON DUPLICATE KEY UPDATE" es la forma más eficiente de insertar o actualizar.
            // Requiere que 'usuario_id' sea una clave ÚNICA en la tabla.
            $stmt = $conn->prepare("
                INSERT INTO nomina_configuracion 
                    (usuario_id, cesta_ticket, complemento_cesta_ticket, bono_transporte, complemento_productividad)
                VALUES (?, ?, ?, ?, ?)
                ON DUPLICATE KEY UPDATE
                    cesta_ticket = VALUES(cesta_ticket),
                    complemento_cesta_ticket = VALUES(complemento_cesta_ticket),
                    bono_transporte = VALUES(bono_transporte),
                    complemento_productividad = VALUES(complemento_productividad)
            ");
            
            $stmt->execute([
                $usuario_id, 
                $cesta_ticket, 
                $comp_cesta_ticket, 
                $bono_transporte, 
                $comp_productividad
            ]);

            registrar_accion('config_nomina_actualizada', "Actualizó la configuración de nómina para el usuario ID {$usuario_id}.");
            $response = ['success' => true, 'message' => 'Configuración guardada exitosamente.'];

        } catch (PDOException $e) {
            error_log(" nomina_configuracion_ajax (guardar): " . $e->getMessage());
            $response['message'] = 'Error de base de datos: ' . $e->getMessage();
        }
        break;
}

echo json_encode($response);