<?php
define('IS_AJAX', true);
require_once '../administracion/includes/seguridad.php';

header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'Acción no válida.'];
$usuario_id = $_SESSION['user_id'] ?? 0;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        $response['message'] = 'Error de seguridad (CSRF).';
        echo json_encode($response);
        exit();
    }
}

$action = $_POST['action'] ?? $_GET['action'] ?? '';

if (!puede('ver_mis_afiliaciones')) {
    $response['message'] = 'Acceso denegado.';
    echo json_encode($response);
    exit();
}

switch ($action) {
    case 'cargar_mis_afiliaciones':
        try {
            $search = $_GET['search'] ?? '';

            // Consulta para PaP (origen = 'PaP')
            $sql_pap = "
                SELECT id, nombre, telefono, campana, zona, estado, observaciones, fecha_asignacion, fecha_ultimo_contacto, origen
                FROM gestion_afiliaciones
                WHERE operador_id = ? AND origen = 'PaP'
            ";
            $params_pap = [$usuario_id];
            if (!empty($search)) {
                $sql_pap .= " AND (nombre LIKE ? OR telefono LIKE ? OR zona LIKE ?)";
                $searchTerm = "%{$search}%";
                array_push($params_pap, $searchTerm, $searchTerm, $searchTerm);
            }
            $stmt_pap = $conn->prepare($sql_pap);
            $stmt_pap->execute($params_pap);
            $afiliaciones_pap = $stmt_pap->fetchAll(PDO::FETCH_ASSOC);

            // Consulta para otros orígenes (origen IS NULL o != 'PaP')
            $sql_otros = "
                SELECT id, nombre, telefono, campana, zona, estado, observaciones, fecha_asignacion, fecha_ultimo_contacto, origen
                FROM gestion_afiliaciones
                WHERE operador_id = ? AND (origen IS NULL OR origen != 'PaP')
            ";
            $params_otros = [$usuario_id];
            if (!empty($search)) {
                $sql_otros .= " AND (nombre LIKE ? OR telefono LIKE ? OR zona LIKE ?)";
                array_push($params_otros, $searchTerm, $searchTerm, $searchTerm);
            }
            $stmt_otros = $conn->prepare($sql_otros);
            $stmt_otros->execute($params_otros);
            $afiliaciones_otros = $stmt_otros->fetchAll(PDO::FETCH_ASSOC);

            // Conteo de pendientes (global, ambas categorías)
            $stmt_pendientes = $conn->prepare("
                SELECT COUNT(*) FROM gestion_afiliaciones 
                WHERE operador_id = ? AND estado = 'Pendiente'
            ");
            $stmt_pendientes->execute([$usuario_id]);
            $pendientes_count = $stmt_pendientes->fetchColumn();

            $response = [
                'success' => true,
                'data_pap' => $afiliaciones_pap,
                'data_otros' => $afiliaciones_otros,
                'pendientes_count' => (int)$pendientes_count,
                'count_pap' => count($afiliaciones_pap),
                'count_otros' => count($afiliaciones_otros)
            ];

        } catch (PDOException $e) {
            error_log("Error en cargar_mis_afiliaciones: " . $e->getMessage());
            $response['message'] = 'Error de base de datos al cargar tus afiliaciones.';
        }
        break;

    case 'actualizar_gestion':
        $gestion_id = filter_input(INPUT_POST, 'gestion_id', FILTER_VALIDATE_INT);
        $estado_nuevo = trim($_POST['estado'] ?? '');
        $zona_nueva = trim($_POST['zona'] ?? '');
        $observacion_adicional = trim($_POST['observaciones'] ?? '');
        // --- MODIFICACIÓN: Recibir el nuevo nombre ---
        $nombre_nuevo = trim($_POST['nombre'] ?? '');

        if (!$gestion_id || empty($estado_nuevo)) {
            $response['message'] = 'Faltan datos para actualizar la gestión.';
            break;
        }

        try {
            $conn->beginTransaction();
            $stmt_check = $conn->prepare("SELECT nombre, estado, zona, observaciones FROM gestion_afiliaciones WHERE id = ? AND operador_id = ?");
            $stmt_check->execute([$gestion_id, $usuario_id]);
            $gestion_actual = $stmt_check->fetch(PDO::FETCH_ASSOC);
            
            if (!$gestion_actual) {
                $conn->rollBack();
                $response['message'] = 'No tienes permiso para modificar esta gestión.';
                break;
            }

            $cambios = [];
            // --- MODIFICACIÓN: Lógica para registrar el cambio de nombre ---
            if (!empty($nombre_nuevo) && $gestion_actual['nombre'] !== $nombre_nuevo) {
                $cambios[] = "actualizó el nombre de '{$gestion_actual['nombre']}' a '{$nombre_nuevo}'";
            } else {
                // Si no se envía un nombre nuevo, se mantiene el actual.
                $nombre_nuevo = $gestion_actual['nombre'];
            }

            if ($gestion_actual['estado'] !== $estado_nuevo) { $cambios[] = "cambió el estado de '{$gestion_actual['estado']}' a '{$estado_nuevo}'"; }
            if ($gestion_actual['zona'] !== $zona_nueva) { $cambios[] = "actualizó la zona de '{$gestion_actual['zona']}' a '{$zona_nueva}'"; }
            
            $notas_para_guardar = $gestion_actual['observaciones'];
            if (!empty($observacion_adicional)) {
                $fecha_actual = date('d/m/Y h:i A');
                $notas_para_guardar .= "\n---\n[{$fecha_actual} - {$_SESSION['user_nombre']}]\n" . $observacion_adicional;
                $cambios[] = "agregó una nueva nota";
            }
            
            // --- MODIFICACIÓN: Se actualiza también el campo 'nombre' en la consulta ---
            $stmt_update = $conn->prepare("UPDATE gestion_afiliaciones SET nombre = ?, estado = ?, zona = ?, observaciones = ?, fecha_ultimo_contacto = NOW() WHERE id = ?");
            $stmt_update->execute([$nombre_nuevo, $estado_nuevo, $zona_nueva, $notas_para_guardar, $gestion_id]);
            
            if (!empty($cambios)) {
                $detalle_log = "Gestionó la afiliación (ID: {$gestion_id}): " . implode(', ', $cambios) . ".";
                registrar_accion('actualiza_gestion_afiliacion', $detalle_log);
            }
            
            $conn->commit();
            $response = ['success' => true, 'message' => 'Gestión actualizada correctamente.'];
        } catch (PDOException $e) {
            $conn->rollBack();
            $response['message'] = 'Error de base de datos al actualizar: ' . $e->getMessage();
        }
        break;

    case 'agregar_contacto_operador':
        // --- MODIFICACIÓN: Asignar 'Sin Nombre' si viene vacío ---
        $nombre = trim($_POST['nombre'] ?? '');
        if (empty($nombre)) {
            $nombre = 'Sin Nombre';
        }
        
        // --- MODIFICACIÓN: Validar y limpiar el número de teléfono ---
        $telefono_raw = trim($_POST['telefono'] ?? '');
        $telefono = preg_replace('/[^0-9]/', '', $telefono_raw); // Elimina todo lo que no sea número
        
        $campana = trim($_POST['campana'] ?? null);

        // --- MODIFICACIÓN: Validar solo el teléfono, ya que el nombre tiene un valor por defecto ---
        if (empty($telefono)) {
            $response['message'] = 'El teléfono es obligatorio y debe contener solo números.';
            break;
        }

        try {
            $stmt = $conn->prepare(
                "INSERT INTO gestion_afiliaciones (nombre, telefono, campana, origen, estado, operador_id, creado_por_id, fecha_asignacion) 
                 VALUES (?, ?, ?, 'PaP', 'Pendiente', ?, ?, NOW())"
            );
            $stmt->execute([$nombre, $telefono, $campana, $usuario_id, $usuario_id]);
            
            registrar_accion('agregar_contacto_PaP', "Operador agregó y se auto-asignó el contacto PaP: '{$nombre}' ({$telefono}).");
            $response = ['success' => true, 'message' => "Se ha agregado '{$nombre}' a tu lista."];

        } catch (PDOException $e) {
            $response['message'] = 'Error al guardar el contacto: ' . $e->getMessage();
            error_log($e->getMessage());
        }
        break;

    default:
        $response['message'] = 'Acción desconocida en este módulo.';
        break;
}

echo json_encode($response);