<?php
define('IS_AJAX', true);
require_once '../administracion/includes/seguridad.php';

header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'Acción no válida.'];

if (!puede('gestionar_equipos')) {
    $response['message'] = 'Acceso denegado.';
    echo json_encode($response);
    exit();
}

// Verificación de token CSRF para acciones POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        $response['message'] = 'Error de seguridad (CSRF).';
        echo json_encode($response);
        exit();
    }
}

$action = $_POST['action'] ?? $_GET['action'] ?? '';

switch ($action) {
    case 'cargar_datos_gestion_equipos':
        try {
            // Obtener todos los supervisores
            $stmt_supervisores = $conn->query("
                SELECT u.id, u.nombre FROM usuarios u
                JOIN roles r ON u.rol_id = r.id WHERE r.clave = 'supervisor' AND u.estado = 1
                ORDER BY u.nombre ASC
            ");
            $supervisores = $stmt_supervisores->fetchAll(PDO::FETCH_ASSOC);

            // Obtener todos los operadores y a qué supervisor pertenecen (si aplica)
            $stmt_operadores = $conn->query("
                SELECT u.id, u.nombre, es.supervisor_id
                FROM usuarios u
                JOIN roles r ON u.rol_id = r.id
                LEFT JOIN equipo_supervisor es ON u.id = es.operador_id
                WHERE r.clave = 'operador' AND u.estado = 1
                ORDER BY u.nombre ASC
            ");
            $operadores = $stmt_operadores->fetchAll(PDO::FETCH_ASSOC);

            $response = [
                'success' => true,
                'data' => [
                    'supervisores' => $supervisores,
                    'operadores' => $operadores
                ]
            ];
        } catch (Exception $e) {
            $response['message'] = 'Error al cargar los datos para la gestión de equipos.';
            error_log('Error en cargar_datos_gestion_equipos: ' . $e->getMessage());
        }
        break;

    case 'guardar_equipo_supervisor':
        $supervisor_id = filter_input(INPUT_POST, 'supervisor_id', FILTER_VALIDATE_INT);
        $operadores_ids = $_POST['operadores_ids'] ?? [];

        if (!$supervisor_id) {
            $response['message'] = 'Debe seleccionar un supervisor válido.';
            break;
        }

        try {
            $conn->beginTransaction();

            // 1. Eliminar todas las asignaciones anteriores para este supervisor
            $stmt_delete = $conn->prepare("DELETE FROM equipo_supervisor WHERE supervisor_id = ?");
            $stmt_delete->execute([$supervisor_id]);

            // 2. Insertar las nuevas asignaciones
            if (!empty($operadores_ids)) {
                $stmt_insert = $conn->prepare("INSERT INTO equipo_supervisor (supervisor_id, operador_id) VALUES (?, ?)");
                foreach ($operadores_ids as $operador_id) {
                    if (filter_var($operador_id, FILTER_VALIDATE_INT)) {
                        $stmt_insert->execute([$supervisor_id, $operador_id]);
                    }
                }
            }
            
            $conn->commit();
            registrar_accion('gestion_equipo', "Actualizó el equipo del supervisor ID: {$supervisor_id}.");
            $response = ['success' => true, 'message' => 'Equipo actualizado correctamente.'];

        } catch (Exception $e) {
            $conn->rollBack();
            $response['message'] = 'Error al guardar los cambios en el equipo.';
            error_log('Error en guardar_equipo_supervisor: ' . $e->getMessage());
        }
        break;

    default:
        $response['message'] = 'Acción de gestión de equipos desconocida.';
        break;
}

echo json_encode($response);