<?php
define('IS_AJAX', true);
require_once '../administracion/includes/seguridad.php';

date_default_timezone_set('America/Caracas');

header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'Acción no válida.'];
$usuario_id = $_SESSION['user_id'] ?? 0;

if (!puede('ver_agendamiento_global')) {
    $response['message'] = 'Acceso denegado.';
    echo json_encode($response);
    exit();
}

$action = $_GET['action'] ?? '';

switch ($action) {
    case 'get_dashboard_por_ruta':
        try {
            $hoy = date('Y-m-d');
            
            // 1. Obtener todas las jornadas futuras de rutas activas, con su conteo de pacientes
            $stmt = $conn->prepare("
                SELECT 
                    r.id as ruta_id,
                    r.nombre_ruta,
                    j.id as jornada_id,
                    j.ciudad_nombre,
                    j.fecha_jornada,
                    COUNT(jc.id) as total_pacientes
                FROM rutas r
                JOIN jornadas j ON r.id = j.ruta_id
                LEFT JOIN jornada_clientes jc ON j.id = jc.jornada_id
                WHERE 
                    r.activa = 1 
                    AND r.archivada = 0 
                    AND j.fecha_jornada >= ?
                GROUP BY j.id
                ORDER BY r.fecha_creacion DESC, j.fecha_jornada ASC
            ");
            $stmt->execute([$hoy]);
            $todas_las_jornadas = $stmt->fetchAll(PDO::FETCH_ASSOC);

            // 2. Procesar en PHP para agrupar por ruta
            $rutas_agrupadas = [];
            foreach ($todas_las_jornadas as $jornada) {
                $ruta_id = $jornada['ruta_id'];

                // Si la ruta no existe en nuestro array, la inicializamos
                if (!isset($rutas_agrupadas[$ruta_id])) {
                    $rutas_agrupadas[$ruta_id] = [
                        'ruta_id' => $ruta_id,
                        'nombre_ruta' => $jornada['nombre_ruta'],
                        'jornadas' => []
                    ];
                }

                // Agregamos la jornada al array de la ruta correspondiente
                $rutas_agrupadas[$ruta_id]['jornadas'][] = [
                    'id' => $jornada['jornada_id'],
                    'ciudad_nombre' => $jornada['ciudad_nombre'],
                    'fecha_jornada' => $jornada['fecha_jornada'],
                    'total_pacientes' => (int)$jornada['total_pacientes']
                ];
            }

            // Convertir el array asociativo a un array indexado para el JSON final
            $response = ['success' => true, 'data' => array_values($rutas_agrupadas)];

        } catch (PDOException $e) {
            error_log("Error en get_dashboard_por_ruta: " . $e->getMessage());
            $response['message'] = 'Error de base de datos al generar el dashboard.';
        }
        break;

    // Dejamos la acción de detalles por si se necesita en el futuro, aunque ahora la usa agendamiento-detalles.php
    case 'get_detalles_jornada_agendada':
        $jornada_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
        if (!$jornada_id) {
            $response['message'] = 'ID de jornada no proporcionado.';
            break;
        }
        try {
            $stmt_jornada_info = $conn->prepare("SELECT j.ciudad_nombre, j.fecha_jornada, r.nombre_ruta FROM jornadas j JOIN rutas r ON j.ruta_id = r.id WHERE j.id = ?");
            $stmt_jornada_info->execute([$jornada_id]);
            $jornada_info = $stmt_jornada_info->fetch(PDO::FETCH_ASSOC);

            if (!$jornada_info) {
                $response['message'] = 'Jornada no encontrada.';
                break;
            }

            $stmt_pacientes = $conn->prepare("
                SELECT
                    jc.id as jornada_cliente_id, c.nombre as paciente_nombre, c.cedula, c.telefono, c.sexo,
                    jc.estado_cita, jc.notas_coordinador, u.nombre as operador_nombre, p.campana 
                FROM jornada_clientes jc
                JOIN clientes c ON jc.cliente_id = c.id
                LEFT JOIN usuarios u ON jc.agendado_por_operador_id = u.id
                LEFT JOIN prospectos p ON c.cedula = p.cedula AND p.cedula IS NOT NULL AND p.cedula != ''
                WHERE jc.jornada_id = ?
                GROUP BY jc.id ORDER BY c.nombre ASC
            ");
            $stmt_pacientes->execute([$jornada_id]);
            $pacientes = $stmt_pacientes->fetchAll(PDO::FETCH_ASSOC);

            $stmt_medicamentos = $conn->prepare("SELECT nombre_medicamento, cantidad FROM jornada_medicamentos WHERE jornada_cliente_id = ?");
            $stmt_examenes = $conn->prepare("SELECT nombre_examen, precio FROM jornada_examenes WHERE jornada_cliente_id = ?");

            foreach($pacientes as &$paciente) {
                $stmt_medicamentos->execute([$paciente['jornada_cliente_id']]);
                $paciente['medicamentos'] = $stmt_medicamentos->fetchAll(PDO::FETCH_ASSOC);
                $stmt_examenes->execute([$paciente['jornada_cliente_id']]);
                $paciente['examenes'] = $stmt_examenes->fetchAll(PDO::FETCH_ASSOC);
            }
            
            $response = ['success' => true, 'data' => ['info' => $jornada_info, 'pacientes' => $pacientes]];
        } catch (PDOException $e) {
            error_log("Error en get_detalles_jornada_agendada: " . $e->getMessage());
            $response['message'] = 'Error de base de datos al cargar los detalles.';
        }
        break;

    default:
        $response['message'] = 'Acción de agendamiento desconocida.';
        break;
}

echo json_encode($response);
?>