<?php
require_once 'includes/seguridad.php';
// Puedes crear un permiso más específico como 'gestionar_visitas_medicas' si lo necesitas.
if (!puede('gestionar_afiliaciones')) {
    header('Location: inicio.php');
    exit;
}
$page_title = 'Visitas Médicas';
include_once 'templates/header.php';

// Esto permite precargar un afiliado si se accede desde afiliaciones.php
$afiliacion_id_precargada = isset($_GET['afiliacion_id']) ? intval($_GET['afiliacion_id']) : 0;
?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@tarekraafat/autocomplete.js@10.2.7/dist/css/autoComplete.min.css">
<style>
    /* Estilos para el autocompletado */
    .autoComplete_wrapper > input { background-color: var(--dark-bg); color: var(--light-text); border: 1px solid var(--border-color); }
    .autoComplete_wrapper > ul { background-color: #2a3038; border: 1px solid var(--border-color); }
    .autoComplete_wrapper > ul > li:hover { background-color: var(--primary-color); }
    
    /* Contenedores principales */
    #resultado-busqueda { display: none; }

    /* Detalles y Suministros */
    .suministro-item { display: flex; gap: 10px; align-items: flex-end; margin-bottom: 15px; background: rgba(0,0,0,0.1); padding: 15px; border-radius: 8px; }
    .suministro-item > .autocomplete-container { flex: 5; }
    .suministro-item > .cantidad-container, .suministro-item > .stock-container { flex: 1; }
    .suministro-item > .remove-btn-container { flex: 0 0 40px; }
    
    /* Indicador de carga */
    .loading-indicator {
        background: rgba(0, 0, 0, 0.1);
        border-radius: 8px;
        padding: 30px;
        text-align: center;
        margin: 20px 0;
        border: 1px solid var(--border-color);
    }
    
    .loading-content p {
        color: var(--light-text);
        font-size: 0.9rem;
    }
    
    .spinner-border {
        width: 2rem;
        height: 2rem;
    }
    
    /* Efecto de deshabilitado para el botón */
    .btn-searching {
        pointer-events: none;
        opacity: 0.6;
    }
    
    .btn-searching .spinner-border {
        width: 1rem;
        height: 1rem;
        margin-right: 5px;
    }
    
    /* Estilos adicionales para el modal de detalles */
    #modalDetalleVisita .modal-body {
        background-color: var(--dark-bg);
        color: var(--light-text);
    }
    
    #modalDetalleVisita .modal-body h6 {
        color: var(--primary-color);
        border-bottom: 1px solid var(--border-color);
        padding-bottom: 5px;
        margin-bottom: 10px;
        margin-top: 15px;
    }
    
    #modalDetalleVisita .modal-body h6:first-child {
        margin-top: 0;
    }
    
    #modalDetalleVisita .modal-body p {
        background: rgba(0,0,0,0.2);
        padding: 8px 12px;
        border-radius: 4px;
        margin-bottom: 10px;
        border-left: 3px solid var(--primary-color);
    }
    
    #modalDetalleVisita .modal-body ul {
        list-style-type: none;
        padding-left: 0;
        background: rgba(0,0,0,0.2);
        padding: 10px;
        border-radius: 4px;
        border-left: 3px solid var(--primary-color);
    }
    
    #modalDetalleVisita .modal-body li {
        margin-bottom: 0.5rem;
        padding: 5px 0;
    }
    
    #modalDetalleVisita .modal-body li strong {
        color: var(--primary-color);
    }
    
    #modalDetalleVisita .modal-body hr {
        border-color: var(--border-color);
        margin: 20px 0;
    }
    
    /* Estilos para la lista de suministros */
    #modalDetalleVisita .modal-body ul li::before {
        content: "•";
        color: var(--primary-color);
        font-weight: bold;
        display: inline-block;
        width: 1em;
        margin-left: -1em;
    }
</style>

<div class="main-header">
    <h1><i class="fa-solid fa-heart-pulse"></i> Historial y Visitas Médicas</h1>
    <p class="lead">Busca un afiliado por la cédula del titular o cualquier miembro de su grupo familiar para ver el historial completo o registrar una nueva consulta.</p>
</div>

<div class="info-card">
    <form id="formBusquedaCedula" class="d-flex gap-2">
        <input type="search" id="cedula_busqueda" class="form-control form-control-dark form-control-lg" placeholder="Ingrese la Cédula del Titular o Miembro" required>
        <button type="submit" class="btn btn-primary btn-lg">Buscar</button>
    </form>
</div>

<!-- Indicador de carga -->
<div id="loading-search" class="loading-indicator" style="display: none;">
    <div class="loading-content">
        <div class="spinner-border text-primary" role="status">
            <span class="visually-hidden">Cargando...</span>
        </div>
        <p class="mt-2 mb-0">Buscando afiliado...</p>
    </div>
</div>

<div id="resultado-busqueda" class="mt-4">
    <div class="info-card" id="info-afiliado">
        </div>
    
    <div class="info-card mt-4" id="historial-visitas">
        <h5><i class="fa-solid fa-book-medical"></i> Historial de Visitas del Grupo Familiar</h5>
        <div class="table-responsive">
            <table class="ami-table">
                <thead>
                    <tr>
                        <th>Fecha</th>
                        <th>Paciente</th>
                        <th>Doctor</th>
                        <th>Motivo</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody id="historial-tbody"></tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade ami-modal-theme" id="modalNuevaVisita" tabindex="-1" data-bs-backdrop="static">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Registrar Nueva Visita</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="formVisitaMedica" autocomplete="off">
                    <input type="hidden" id="afiliacion_id" name="afiliacion_id">
                    <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                    <h6>Paciente a ser atendido</h6>
                    <select class="form-select form-select-dark mb-3" id="miembro_id" name="miembro_id" required></select>

                    <h6>Detalles de la Consulta</h6>
                    <p><strong>Atendido por:</strong> <?php echo htmlspecialchars($usuario_actual['nombre']); ?></p>
                    <div class="row">
                        <div class="col-md-6 mb-3"><label for="fecha_visita">Fecha y Hora</label><input type="datetime-local" class="form-control form-control-dark" id="fecha_visita" name="fecha_visita" required></div>
                        <div class="col-md-6 mb-3"><label for="motivo_consulta">Motivo de Consulta</label><textarea class="form-control form-control-dark" id="motivo_consulta" name="motivo_consulta" rows="2" required></textarea></div>
                    </div>
                    <div class="mb-3"><label for="diagnostico">Diagnóstico y Hallazgos</label><textarea class="form-control form-control-dark" id="diagnostico" name="diagnostico" rows="4"></textarea></div>
                    <div class="mb-3"><label for="tratamiento">Tratamiento y Receta</label><textarea class="form-control form-control-dark" id="tratamiento" name="tratamiento" rows="4"></textarea></div>
                    <div class="mb-3"><label for="notas_medicas">Notas Adicionales</label><textarea class="form-control form-control-dark" id="notas_medicas" name="notas_medicas" rows="2"></textarea></div>

                    <hr class="my-4">
                    <h6>Suministros Utilizados</h6>
                    <div id="suministros-container"></div>
                    <button type="button" id="btnAgregarSuministro" class="btn btn-outline-info btn-sm"><i class="fa-solid fa-plus"></i> Añadir Medicamento/Suministro</button>
                    
                    <div class="mt-4 text-end">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary"><i class="fa-solid fa-save"></i> Guardar Visita</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade ami-modal-theme" id="modalDetalleVisita" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Detalles de la Visita</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="detalle-visita-body">
                </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>


<script src="https://cdn.jsdelivr.net/npm/@tarekraafat/autocomplete.js@10.2.7/dist/autoComplete.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const formBusqueda = document.getElementById('formBusquedaCedula');
    const resultadoDiv = document.getElementById('resultado-busqueda');
    const afiliadoIdInput = document.getElementById('afiliacion_id');
    const historialBody = document.getElementById('historial-tbody');
    let suministroIndex = 0;

    // Función para mostrar/ocultar loading en botones
    function toggleButtonLoading(button, isLoading, loadingText = 'Cargando...', normalText = null) {
        if (isLoading) {
            button.disabled = true;
            button.dataset.originalText = button.innerHTML;
            button.innerHTML = `<span class="spinner-border spinner-border-sm me-2" role="status"></span>${loadingText}`;
            button.classList.add('btn-searching');
        } else {
            button.disabled = false;
            button.innerHTML = normalText || button.dataset.originalText || button.innerHTML.replace(/.*<\/span>/, '');
            button.classList.remove('btn-searching');
        }
    }

    formBusqueda.addEventListener('submit', function(e) {
        e.preventDefault();
        const cedula = document.getElementById('cedula_busqueda').value;
        buscarAfiliado(cedula);
    });
    
    function buscarAfiliado(cedula) {
        const loadingDiv = document.getElementById('loading-search');
        const searchButton = document.querySelector('#formBusquedaCedula button[type="submit"]');
        
        // Ocultar resultados previos y mostrar loading
        resultadoDiv.style.display = 'none';
        loadingDiv.style.display = 'block';
        
        // Deshabilitar botón
        toggleButtonLoading(searchButton, true, 'Buscando...');
        
        fetch(`/api/visitas_ajax.php?action=buscar_afiliado_por_cedula&cedula=${cedula}`)
        .then(res => res.json())
        .then(data => {
            loadingDiv.style.display = 'none';
            toggleButtonLoading(searchButton, false, '', 'Buscar');
            
            if (data.success) {
                mostrarResultados(data);
            } else {
                Swal.fire('No Encontrado', data.message, 'warning');
            }
        })
        .catch(error => {
            loadingDiv.style.display = 'none';
            toggleButtonLoading(searchButton, false, '', 'Buscar');
            console.error('Error:', error);
            Swal.fire('Error de Conexión', 'No se pudo realizar la búsqueda. Inténtelo nuevamente.', 'error');
        });
    }

    function mostrarResultados(data) {
        // Mostrar info del afiliado
        const infoDiv = document.getElementById('info-afiliado');
        const estadoBadge = data.afiliado.estado === 'Activo' ? 'bg-success' : 'bg-danger';
        
        // Determinar si la búsqueda fue por miembro o por titular
        let infoAdicional = '';
        if (data.miembro_buscado) {
            // Se encontró a través de un miembro
            infoAdicional = `
                <div class="alert alert-info mb-3">
                    <i class="fa-solid fa-info-circle"></i> 
                    <strong>Búsqueda por Miembro:</strong> Se encontró la cédula en 
                    <strong>${data.miembro_buscado.nombre} ${data.miembro_buscado.apellido}</strong> 
                    (${data.miembro_buscado.parentesco}) - C.I: ${data.miembro_buscado.cedula}
                </div>`;
        }
        
        infoDiv.innerHTML = `
            ${infoAdicional}
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h5><strong>Contrato:</strong> ${data.afiliado.numero_contrato}</h5>
                    <p class="mb-0"><strong>Titular:</strong> ${data.afiliado.nombre_titular} ${data.afiliado.apellido_titular} | <strong>C.I:</strong> ${data.afiliado.cedula_titular}</p>
                    <p class="mb-0"><strong>Estado:</strong> <span class="badge ${estadoBadge}">${data.afiliado.estado}</span></p>
                </div>
                <button class="btn btn-primary btn-lg" id="btnAbrirModalVisita"><i class="fa-solid fa-plus"></i> Registrar Nueva Visita</button>
            </div>`;
        
        // Llenar tabla de historial
        historialBody.innerHTML = '';
        if (data.historial.length > 0) {
            data.historial.forEach(visita => {
                const fecha = new Date(visita.fecha_visita).toLocaleString('es-ES');
                historialBody.innerHTML += `
                    <tr>
                        <td>${fecha}</td>
                        <td>${visita.paciente_nombre}</td>
                        <td>${visita.doctor_nombre}</td>
                        <td>${visita.motivo_consulta}</td>
                        <td><button class="btn btn-sm btn-outline-info btn-ver-detalle" data-id="${visita.id}"><i class="fa-solid fa-eye"></i> Ver</button></td>
                    </tr>
                `;
            });
        } else {
            historialBody.innerHTML = '<tr><td colspan="5" class="text-center">Este afiliado no tiene visitas registradas.</td></tr>';
        }

        // Preparar modal de nueva visita
        afiliadoIdInput.value = data.afiliado.id;
        const miembroSelect = document.getElementById('miembro_id');
        miembroSelect.innerHTML = '';
        
        // Pre-seleccionar al miembro buscado si existe
        let miembroPreseleccionado = null;
        data.miembros.forEach(miembro => {
            miembroSelect.add(new Option(miembro.nombre, miembro.id));
            
            // Si se buscó por miembro, identificar cuál pre-seleccionar
            if (data.miembro_buscado && miembro.id === 'M_' + data.miembro_buscado.id) {
                miembroPreseleccionado = miembro.id;
            }
        });
        
        // Pre-seleccionar el miembro si se encontró por miembro
        if (miembroPreseleccionado) {
            miembroSelect.value = miembroPreseleccionado;
        }

        resultadoDiv.style.display = 'block';

        document.getElementById('btnAbrirModalVisita').addEventListener('click', () => {
             const now = new Date();
             now.setMinutes(now.getMinutes() - now.getTimezoneOffset());
             document.getElementById('fecha_visita').value = now.toISOString().slice(0,16);
             document.getElementById('formVisitaMedica').reset(); // Limpiar formulario
             document.getElementById('suministros-container').innerHTML = ''; // Limpiar suministros
             afiliadoIdInput.value = data.afiliado.id; // Reasignar ID
             
             // Volver a llenar el select de miembros y pre-seleccionar si corresponde
             const miembroSelect = document.getElementById('miembro_id');
             miembroSelect.innerHTML = '';
             data.miembros.forEach(miembro => {
                 miembroSelect.add(new Option(miembro.nombre, miembro.id));
             });
             
             // Pre-seleccionar el miembro si se buscó por miembro
             if (miembroPreseleccionado) {
                 miembroSelect.value = miembroPreseleccionado;
             }
             
             new bootstrap.Modal(document.getElementById('modalNuevaVisita')).show();
        });
    }
    
    // Ver detalles de una visita pasada con loading
    historialBody.addEventListener('click', function(e){
        if (e.target.closest('.btn-ver-detalle')) {
            const visitaId = e.target.closest('.btn-ver-detalle').dataset.id;
            const button = e.target.closest('.btn-ver-detalle');
            
            toggleButtonLoading(button, true, 'Cargando...');
            
            fetch(`/api/visitas_ajax.php?action=get_visita_detalle&id=${visitaId}`)
                .then(res => res.json())
                .then(data => {
                    toggleButtonLoading(button, false, '', '<i class="fa-solid fa-eye"></i> Ver');
                    
                    if (data.success) {
                        const v = data.visita;
                        let suministrosHtml = '<h6>Suministros Utilizados:</h6>';
                        if(data.suministros.length > 0) {
                            suministrosHtml += '<ul>';
                            data.suministros.forEach(s => {
                                suministrosHtml += `<li>${s.cantidad_usada} x ${s.producto_nombre}</li>`;
                            });
                            suministrosHtml += '</ul>';
                        } else {
                            suministrosHtml += '<p>No se registraron suministros.</p>';
                        }

                        document.getElementById('detalle-visita-body').innerHTML = `
                            <ul>
                                <li><strong>Paciente:</strong> ${v.paciente_nombre}</li>
                                <li><strong>Fecha:</strong> ${new Date(v.fecha_visita).toLocaleString('es-ES')}</li>
                                <li><strong>Doctor:</strong> ${v.doctor_nombre}</li>
                            </ul>
                            <hr>
                            <h6>Motivo de Consulta:</h6><p>${v.motivo_consulta || 'No especificado'}</p>
                            <h6>Diagnóstico:</h6><p>${v.diagnostico || 'No especificado'}</p>
                            <h6>Tratamiento:</h6><p>${v.tratamiento || 'No especificado'}</p>
                            <h6>Notas Adicionales:</h6><p>${v.notas_medicas || 'Ninguna'}</p>
                            <hr>
                            ${suministrosHtml}
                        `;
                        new bootstrap.Modal(document.getElementById('modalDetalleVisita')).show();
                    } else {
                        Swal.fire('Error', data.message, 'error');
                    }
                })
                .catch(error => {
                    toggleButtonLoading(button, false, '', '<i class="fa-solid fa-eye"></i> Ver');
                    console.error('Error:', error);
                    Swal.fire('Error de Conexión', 'No se pudieron cargar los detalles.', 'error');
                });
        }
    });

    // --- MANEJO DINÁMICO DE SUMINISTROS EN EL MODAL ---
    const suministrosContainer = document.getElementById('suministros-container');
    document.getElementById('btnAgregarSuministro').addEventListener('click', () => {
        suministroIndex++;
        const itemHtml = `
            <div class="suministro-item" id="suministro_item_${suministroIndex}">
                <input type="hidden" class="suministro-id" name="suministros[${suministroIndex}][id]">
                <div class="autocomplete-container">
                    <label class="form-label">Producto</label>
                    <div class="autoComplete_wrapper">
                        <input id="producto_search_${suministroIndex}" type="text" class="form-control form-control-dark producto-search" placeholder="Buscar producto..." required>
                    </div>
                </div>
                <div class="cantidad-container">
                    <label class="form-label">Cantidad</label>
                    <input type="number" name="suministros[${suministroIndex}][cantidad]" class="form-control form-control-dark suministro-cantidad" min="1" value="1" required>
                </div>
                <div class="stock-container">
                    <label class="form-label">Stock</label>
                    <input type="text" class="form-control form-control-dark stock-display" readonly value="N/A">
                </div>
                <div class="remove-btn-container">
                    <button type="button" class="btn btn-danger btn-remove-suministro"><i class="fa-solid fa-trash"></i></button>
                </div>
            </div>`;
        suministrosContainer.insertAdjacentHTML('beforeend', itemHtml);
        
        const newItem = document.getElementById(`suministro_item_${suministroIndex}`);
        new autoComplete({
            selector: `#producto_search_${suministroIndex}`,
            data: { src: async q => await fetch(`/api/visitas_ajax.php?action=buscar_productos&term=${q}`).then(r => r.json()), keys: ["nombre"] },
            resultItem: { highlight: true, element: (item, data) => { item.innerHTML = `<span>${data.match}</span> <small>(Stock: ${data.value.stock})</small>`; } },
            events: {
                input: {
                    selection: (event) => {
                        const selection = event.detail.selection.value;
                        newItem.querySelector('.producto-search').value = selection.nombre;
                        newItem.querySelector('.suministro-id').value = selection.id;
                        newItem.querySelector('.stock-display').value = selection.stock;
                        newItem.querySelector('.suministro-cantidad').max = selection.stock;
                    }
                }
            }
        });
    });

    suministrosContainer.addEventListener('click', (e) => {
        if (e.target.closest('.btn-remove-suministro')) {
            e.target.closest('.suministro-item').remove();
        }
    });

    // --- GUARDAR FORMULARIO DE NUEVA VISITA CON LOADING ---
    document.getElementById('formVisitaMedica').addEventListener('submit', function(e) {
        e.preventDefault();
        const submitButton = e.target.querySelector('button[type="submit"]');
        
        Swal.fire({
            title: '¿Confirmar Registro?',
            text: "Se guardará la visita y se descontarán los suministros del inventario.",
            icon: 'question', showCancelButton: true, confirmButtonText: 'Sí, Guardar', cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                const formData = new FormData(e.target);
                formData.append('action', 'guardar_visita');
                
                toggleButtonLoading(submitButton, true, 'Guardando...');
                
                fetch('/api/visitas_ajax.php', { method: 'POST', body: formData })
                .then(res => res.json())
                .then(data => {
                    toggleButtonLoading(submitButton, false, '', '<i class="fa-solid fa-save"></i> Guardar Visita');
                    
                    if (data.success) {
                        Swal.fire('¡Guardado!', data.message, 'success').then(() => {
                           bootstrap.Modal.getInstance(document.getElementById('modalNuevaVisita')).hide();
                           // Recargar los resultados
                           const cedulaBusqueda = document.getElementById('cedula_busqueda').value;
                           buscarAfiliado(cedulaBusqueda);
                        });
                    } else { 
                        Swal.fire('Error', data.message, 'error'); 
                    }
                })
                .catch(error => {
                    toggleButtonLoading(submitButton, false, '', '<i class="fa-solid fa-save"></i> Guardar Visita');
                    console.error('Error:', error);
                    Swal.fire('Error de Conexión', 'No se pudo enviar el formulario.', 'error');
                });
            }
        });
    });

});
</script>

<?php include_once 'templates/footer.php'; ?>