<?php
require_once 'includes/seguridad.php';
if (!puede('crear_venta_operador')) {
    header('Location: inicio.php?error=acceso_denegado');
    exit();
}
$page_title = 'Registrar Nueva Venta';
include_once 'templates/header.php';
?>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />

<style>
    /* === ESTILOS GENERALES PARA TEMA OSCURO === */
    body {
        background-color: #1c2128; 
    }
    .main-header h1 {
        font-weight: 600;
        color: #fff; 
    }
    .main-header p {
        color: #adb5bd; 
    }

    /* === ESTILOS PARA LAS TARJETAS (CARDS) OSCURAS === */
    .info-card, .card {
        background-color: #2d333b; 
        border-radius: 10px;
        border: 1px solid #444c56; 
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        color: #cdd9e5; 
    }
    .card-header-custom {
        background-color: transparent;
        border-bottom: 1px solid #444c56; 
        padding: 1rem 1.5rem;
        font-size: 1.1rem;
        font-weight: 600;
        color: #fff; 
    }

    /* === ESTILOS PARA CAMPOS DE FORMULARIO OSCUROS === */
    .form-control, .form-select {
        background-color: #22272e; 
        color: #cdd9e5; 
        border: 1px solid #444c56;
    }
    .form-control:focus, .form-select:focus {
        background-color: #22272e;
        color: #cdd9e5;
        border-color: var(--bs-primary); 
        box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
    }
    .form-label {
        color: #adb5bd; 
    }

    /* === ESTILOS PARA SELECT2 EN TEMA OSCURO === */
    .select2-container--bootstrap-5 .select2-selection {
        background-color: #22272e;
        border: 1px solid #444c56;
        color: #cdd9e5;
    }
    .select2-container--bootstrap-5 .select2-selection--single .select2-selection__rendered {
    color: #cdd9e5;
}
    .select2-container--bootstrap-5 .select2-dropdown {
        background-color: #2d333b; 
        border-color: #444c56;
    }
    .select2-container--bootstrap-5 .select2-results__option {
        color: #cdd9e5; 
    }
    .select2-container--bootstrap-5 .select2-results__option--highlighted {
        background-color: var(--bs-primary); 
        color: #fff;
    }
     .select2-container--bootstrap-5 .select2-search--dropdown .select2-search__field {
        background-color: #22272e;
        color: #cdd9e5;
    }

    /* === ESTILOS PARA LA LISTA DE PRODUCTOS OSCURA === */
    .producto-item-header, .producto-item {
        display: grid;
        grid-template-columns: 1fr 100px 120px 120px 50px;
        gap: 1rem;
        align-items: center;
        margin-bottom: 0.5rem;
    }
    .producto-item-header {
        font-weight: 600;
        color: #848d97; 
        font-size: 0.8rem;
        text-transform: uppercase;
        padding-bottom: 0.5rem;
        border-bottom: 1px solid #444c56;
    }
    .producto-item { margin-bottom: 1rem; }

    /* === ESTILO PARA EL TOTAL OSCURO === */
    .total-display {
        background-color: rgba(13, 110, 253, 0.1); 
        border: 2px solid var(--bs-primary);
        font-size: 1.5rem;
        font-weight: 700;
        color: #fff; 
        text-align: center;
    }
    
    /* === ¡NUEVO! ESTILOS PARA MODALES OSCUROS === */
    .modal-content {
        background-color: #2d333b;
        color: #cdd9e5;
        border: 1px solid #444c56;
    }
    .modal-header {
        border-bottom: 1px solid #444c56;
    }
    .modal-footer {
        border-top: 1px solid #444c56;
    }
    .modal-header .btn-close {
        /* Invierte el color del botón 'X' para que sea blanco */
        filter: invert(1) grayscale(100%) brightness(200%);
    }
</style>

<div class="main-header">
    <h1><i class="fa-solid fa-cash-register"></i> <?php echo $page_title; ?></h1>
    <p class="text-muted">Rellena los datos para generar una nueva orden de venta.</p>
</div>

<form id="form-nueva-venta" class="p-0 info-card" enctype="multipart/form-data">
    <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">

    <div class="card mb-4 shadow-sm">
        <div class="card-header-custom">
            <h4><i class="fa-solid fa-user-tag text-primary"></i> 1. Datos del Cliente y Envío</h4>
        </div>
        <div class="card-body p-4">
            <div class="row">
                <div class="col-md-12 mb-3">
                    <label class="form-label fw-bold">Buscar o Crear Cliente</label>
                    <select id="cliente-selector" name="cliente_id" class="form-select" required></select>
                </div>
                <div class="col-md-12 mb-3">
                    <label class="form-label fw-bold">Dirección Detallada de Entrega</label>
                    <textarea name="direccion_entrega" class="form-control" rows="2" required placeholder="Ej: Av. Principal, Edificio ABC, Piso 1, Apto 1A..."></textarea>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label fw-bold">Ciudad</label>
                    <input type="text" name="ciudad" class="form-control" required placeholder="Ej: Caracas">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label fw-bold">Estado</label>
                    <input type="text" name="estado_ve" class="form-control" required placeholder="Ej: Distrito Capital">
                </div>
            </div>
        </div>
    </div>

    <div class="card mb-4 shadow-sm">
        <div class="card-header-custom">
            <h4><i class="fa-solid fa-boxes-stacked text-primary"></i> 2. Productos de la Venta</h4>
        </div>
        <div class="card-body p-4">
            <div class="producto-item-header d-none d-md-grid">
                <label>Producto</label>
                <label>Cantidad</label>
                <label>Precio Unit. ($)</label>
                <label>Subtotal ($)</label>
                <label>Acción</label>
            </div>
            <div id="productos-container"></div>
            <button type="button" class="btn btn-outline-success mt-2" id="btn-agregar-producto"><i class="fa-solid fa-plus"></i> Añadir Producto</button>
        </div>
    </div>

    <div class="card shadow-sm">
        <div class="card-header-custom">
            <h4><i class="fa-solid fa-file-invoice-dollar text-primary"></i> 3. Detalles del Pago y Cierre</h4>
        </div>
        <div class="card-body p-4">
            <div class="row align-items-center">
                 <div class="col-md-9">
                    <div class="row">
                        <div class="col-md-4 mb-3"><label class="form-label fw-bold">Método de Pago</label><select name="metodo_pago" class="form-select" required><option value="Zelle">Zelle</option><option value="Efectivo">Efectivo</option><option value="Pago Móvil">Pago Móvil</option><option value="Transferencia">Transferencia</option></select></div>
                        <div class="col-md-4 mb-3"><label class="form-label fw-bold">Nº Referencia</label><input type="text" name="referencia_pago" class="form-control"></div>
                        <div class="col-md-4 mb-3"><label class="form-label fw-bold">Fecha de Venta</label><input type="date" name="fecha_venta" class="form-control" required></div>
                    </div>
                 </div>
                 <div class="col-md-3 mb-3">
                    <label class="form-label fw-bold text-center d-block">Monto Total ($)</label>
                    <input type="text" name="monto_total" class="form-control total-display" required readonly>
                </div>
            </div>
            <div class="mb-3">
                <label class="form-label fw-bold">Comprobante de Pago (Opcional)</label>
                <input type="file" name="comprobante_pago" class="form-control" accept="image/*">
            </div>
            <div class="mb-3">
                <label class="form-label fw-bold">Observaciones Adicionales</label>
                <textarea name="observaciones" class="form-control" rows="2" placeholder="Cualquier detalle importante sobre la venta o el envío..."></textarea>
            </div>
        </div>
    </div>

    <div class="text-end mt-4">
        <button type="submit" class="btn btn-primary btn-lg px-5 py-3"><i class="fa-solid fa-save me-2"></i> Registrar Venta</button>
    </div>
</form>

<div class="modal fade" id="modal-nuevo-cliente" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title"><i class="fa-solid fa-user-plus"></i> Registrar Nuevo Cliente</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form id="form-nuevo-cliente">
          <div class="mb-3">
            <label class="form-label">Nombre Completo</label>
            <input type="text" id="nuevo-cliente-nombre" class="form-control" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Cédula de Identidad (Opcional)</label>
            <input type="text" id="nuevo-cliente-cedula" class="form-control">
          </div>
           <div class="mb-3">
            <label class="form-label">Teléfono (Opcional)</label>
            <input type="text" id="nuevo-cliente-telefono" class="form-control">
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        <button type="button" class="btn btn-primary" id="btn-guardar-cliente">Guardar Cliente</button>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="modal-agregar-cedula" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title"><i class="fa-solid fa-id-card"></i> Agregar Cédula</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p>El cliente <strong id="nombre-cliente-sin-cedula"></strong> no tiene una cédula registrada. Por favor, agrégala para continuar.</p>
        <form id="form-agregar-cedula">
          <input type="hidden" id="update-cliente-id">
          <div class="mb-3">
            <label class="form-label">Cédula de Identidad</label>
            <input type="text" id="update-cliente-cedula" class="form-control" required>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        <button type="button" class="btn btn-primary" id="btn-actualizar-cedula">Actualizar Cédula</button>
      </div>
    </div>
  </div>
</div>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    let productoIndex = 0;
    const nuevoClienteModal = new bootstrap.Modal(document.getElementById('modal-nuevo-cliente'));
    const agregarCedulaModal = new bootstrap.Modal(document.getElementById('modal-agregar-cedula'));

    // --- LÓGICA DEL SELECTOR DE CLIENTES ---
    $('#cliente-selector').select2({
        theme: "bootstrap-5",
        placeholder: 'Busca por nombre o cédula...',
        ajax: {
            url: '/api/ventas_ajax.php',
            dataType: 'json',
            delay: 250,
            data: params => ({ q: params.term, action: 'buscar_clientes' }),
            processResults: function (data, params) {
                const term = params.term || '';
                if (term.length > 2 && !data.data.some(item => item.text.toLowerCase().includes(term.toLowerCase()))) {
                     data.data.push({ id: 'new_client', text: `<strong><i class="fa-solid fa-plus"></i> Registrar "${term}" como nuevo cliente</strong>`, is_new: true });
                }
                return { results: data.data };
            },
            cache: true
        },
        escapeMarkup: markup => markup 
    }).on('select2:select', function(e) {
        const data = e.params.data;
        if (data.is_new) {
            $('#cliente-selector').val(null).trigger('change');
            document.getElementById('nuevo-cliente-nombre').value = $(this).data('select2').dropdown.$search.val();
            nuevoClienteModal.show();
        } else if (data.needs_cedula) {
            document.getElementById('update-cliente-id').value = data.id;
            document.getElementById('nombre-cliente-sin-cedula').textContent = data.text.split('(')[0].trim();
            agregarCedulaModal.show();
        }
    });

    // --- LÓGICA DE MODALES DE CLIENTE ---
    document.getElementById('btn-guardar-cliente').addEventListener('click', function() {
        const nombre = document.getElementById('nuevo-cliente-nombre').value;
        const cedula = document.getElementById('nuevo-cliente-cedula').value;
        const telefono = document.getElementById('nuevo-cliente-telefono').value;
        if (!nombre) { Swal.fire('Error', 'El nombre es obligatorio.', 'error'); return; }

        const formData = new FormData();
        formData.append('action', 'crear_cliente');
        formData.append('nombre', nombre);
        formData.append('cedula', cedula);
        formData.append('telefono', telefono);
        formData.append('csrf_token', '<?php echo $_SESSION['csrf_token']; ?>');

        fetch('/api/ventas_ajax.php', { method: 'POST', body: formData })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                const newOption = new Option(data.cliente.text, data.cliente.id, true, true);
                $('#cliente-selector').append(newOption).trigger('change');
                nuevoClienteModal.hide();
                document.getElementById('form-nuevo-cliente').reset();
                Swal.fire('¡Éxito!', 'Cliente creado correctamente.', 'success');
            } else { Swal.fire('Error', data.message, 'error'); }
        });
    });

    document.getElementById('btn-actualizar-cedula').addEventListener('click', function() {
        const clienteId = document.getElementById('update-cliente-id').value;
        const cedula = document.getElementById('update-cliente-cedula').value;
        if (!cedula) { Swal.fire('Error', 'La cédula es obligatoria.', 'error'); return; }
        
        const formData = new FormData();
        formData.append('action', 'actualizar_cliente_cedula');
        formData.append('cliente_id', clienteId);
        formData.append('cedula', cedula);
        formData.append('csrf_token', '<?php echo $_SESSION['csrf_token']; ?>');

        fetch('/api/ventas_ajax.php', { method: 'POST', body: formData })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                agregarCedulaModal.hide();
                document.getElementById('form-agregar-cedula').reset();
                Swal.fire('¡Éxito!', 'Cédula actualizada.', 'success');
                 const option = $('#cliente-selector').find('option:selected');
                 option.text(data.new_text);
                 $('#cliente-selector').trigger('change');
            } else { Swal.fire('Error', data.message, 'error'); }
        });
    });

    // --- LÓGICA DE PRODUCTOS ---
    document.getElementById('btn-agregar-producto').addEventListener('click', function() {
        productoIndex++;
        const container = document.getElementById('productos-container');
        const productoHtml = `
            <div class="producto-item" id="producto-${productoIndex}">
                <select name="productos[${productoIndex}][id]" class="form-select producto-selector" required></select>
                <input type="number" name="productos[${productoIndex}][cantidad]" class="form-control cantidad-input" min="1" value="1" required placeholder="Cant.">
                <input type="number" step="0.01" name="productos[${productoIndex}][precio]" class="form-control precio-input" required placeholder="Precio Unit. ($)">
                <input type="text" class="form-control subtotal-display" readonly placeholder="Subtotal ($)">
                <button type="button" class="btn btn-danger btn-sm" onclick="this.closest('.producto-item').remove(); calcularTotal();"><i class="fa-solid fa-trash"></i></button>
            </div>
        `;
        container.insertAdjacentHTML('beforeend', productoHtml);
        $(`#producto-${productoIndex} .producto-selector`).select2({
            theme: "bootstrap-5",
            placeholder: 'Busca un producto...',
            ajax: {
                url: '/api/ventas_ajax.php',
                dataType: 'json',
                delay: 250,
                data: params => ({ q: params.term, action: 'buscar_productos' }),
                processResults: function (data) { return { results: data.data }; },
                cache: true
            }
        });
    });

    // --- CÁLCULO DE TOTALES ---
    document.getElementById('productos-container').addEventListener('input', function(e) {
        if (e.target.classList.contains('cantidad-input') || e.target.classList.contains('precio-input')) {
            calcularTotal();
        }
    });

    function calcularTotal() {
        let total = 0;
        document.querySelectorAll('.producto-item').forEach(item => {
            const cantidad = parseFloat(item.querySelector('.cantidad-input').value) || 0;
            const precio = parseFloat(item.querySelector('.precio-input').value) || 0;
            const subtotal = cantidad * precio;
            item.querySelector('.subtotal-display').value = subtotal.toFixed(2);
            total += subtotal;
        });
        document.querySelector('input[name="monto_total"]').value = total.toFixed(2);
    }
    
    // --- ENVÍO DEL FORMULARIO PRINCIPAL ---
    document.getElementById('form-nueva-venta').addEventListener('submit', function(e) {
        e.preventDefault();
        const formData = new FormData(this);
        formData.append('action', 'registrar_venta');

        Swal.fire({
            title: 'Registrando Venta...',
            text: 'Por favor, espera un momento.',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading()
            }
        });

        fetch('/api/ventas_ajax.php', {
            method: 'POST',
            body: formData
        })
        .then(res => res.json())
        .then(data => {
            if(data.success) {
                Swal.fire('¡Éxito!', data.message, 'success').then(() => {
                    window.location.href = 'inicio.php';
                });
            } else {
                Swal.fire('Error', data.message, 'error');
            }
        })
        .catch(err => {
            Swal.fire('Error de Conexión', 'No se pudo conectar con el servidor para registrar la venta. Revisa tu conexión a internet.', 'error');
            console.error('Fetch Error:', err);
        });
    });

    // --- VALORES INICIALES ---
    document.querySelector('input[name="fecha_venta"]').valueAsDate = new Date();
});
</script>

<?php include_once 'templates/footer.php'; ?>