<?php
require_once 'includes/seguridad.php'; 
$page_title = 'Administración de Rutas';
include_once 'templates/header.php';

if (!puede('gestionar_rutas_admin')) {
    echo "<main class='ami-content'><div class='info-card'><h1>Acceso Denegado</h1></div></main>";
    include_once 'templates/footer.php';
    exit();
}
?>

<style>
.badge-activa {
    background-color: var(--primary-color);
    color: var(--dark-text);
    font-weight: bold;
    border: 1px solid rgba(255,255,255,0.5);
}
.equipo-lista {
    font-size: 0.85em;
    line-height: 1.5;
}
.equipo-lista strong {
    color: var(--primary-color);
    opacity: 0.8;
}
/* Estilos para las nuevas pestañas */
.nav-tabs .nav-link {
    background-color: transparent;
    border-color: var(--border-color);
    color: var(--light-text);
}
.nav-tabs .nav-link.active {
    background-color: var(--primary-color);
    border-color: var(--primary-color);
    color: var(--dark-text);
    font-weight: bold;
}
</style>

<div class="main-header">
    <h1><?php echo $page_title; ?></h1>
    <div>
        <a href="ruta-asignar-operadores.php" class="btn btn-info"><i class="fa-solid fa-users"></i> Asignar Operadores</a>
        <a href="ruta-crear.php" class="btn-add-new"><i class="fa-solid fa-plus"></i> Crear Nueva Ruta</a>
    </div>
</div>

<div class="info-card">
    <ul class="nav nav-tabs" id="rutasTab" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="activas-tab" data-bs-toggle="tab" data-bs-target="#activas" type="button" role="tab">Rutas Activas</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="archivadas-tab" data-bs-toggle="tab" data-bs-target="#archivadas" type="button" role="tab">Rutas Archivadas</button>
        </li>
    </ul>

    <div class="tab-content pt-3">
        <div class="tab-pane fade show active" id="activas" role="tabpanel">
            <div class="table-responsive">
                <table class="ami-table">
                    <thead>
                        <tr>
                            <th>Nombre de la Ruta</th>
                            <th>Equipo Asignado</th>
                            <th class="text-center">Jornadas</th>
                            <th>Fecha Creación</th>
                            <th class="text-center">Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody id="activasTableBody"></tbody>
                </table>
            </div>
        </div>
        <div class="tab-pane fade" id="archivadas" role="tabpanel">
            <div class="table-responsive">
                <table class="ami-table">
                    <thead>
                        <tr>
                            <th>Nombre de la Ruta</th>
                            <th>Equipo Asignado</th>
                            <th class="text-center">Jornadas</th>
                            <th>Fecha Creación</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody id="archivadasTableBody"></tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include_once 'templates/footer.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const csrfToken = '<?php echo $_SESSION['csrf_token']; ?>';

    function formatearFecha(fechaStr) {
        if (!fechaStr) return 'N/A';
        const fecha = new Date(fechaStr.replace(' ', 'T'));
        return fecha.toLocaleString('es-VE', {
            day: '2-digit', month: '2-digit', year: 'numeric',
            hour: '2-digit', minute: '2-digit', hour12: true
        });
    }

    function cargarRutasAdmin() {
        fetch('/api/rutas_ajax.php?action=cargar_rutas_admin_separadas')
        .then(res => res.json())
        .then(data => {
            if (!data.success) { Swal.fire('Error', data.message, 'error'); return; }
            renderizarTabla('activasTableBody', data.data.activas_planificadas, true);
            renderizarTabla('archivadasTableBody', data.data.pasadas, false);
        });
    }

    function renderizarTabla(tbodyId, rutas, esActiva) {
        const tablaBody = document.getElementById(tbodyId);
        tablaBody.innerHTML = '';
        if (rutas.length === 0) {
            const colspan = esActiva ? 6 : 5;
            tablaBody.innerHTML = `<tr><td colspan="${colspan}" class="text-center">No hay rutas en esta sección.</td></tr>`;
            return;
        }

        rutas.forEach(r => {
            const estadoHtml = r.activa == 1
                ? `<span class="badge badge-activa"><i class="fa-solid fa-star"></i> Activa</span>`
                : `<span class="badge bg-secondary">Inactiva</span>`;
            
            const botonActivarHtml = `<button class="btn btn-sm ${r.activa == 1 ? 'btn-outline-warning' : 'btn-primary'}" onclick="cambiarEstadoRuta(${r.id})" title="${r.activa == 1 ? 'Desactivar' : 'Activar'}"><i class="fa-solid ${r.activa == 1 ? 'fa-power-off' : 'fa-play'}"></i></button>`;
            const botonArchivarHtml = `<button class="btn btn-sm btn-outline-secondary" onclick="archivarRuta(${r.id})" title="Archivar Ruta"><i class="fa-solid fa-archive"></i></button>`;
            
            let acciones = `
                <a href="ruta-detalle.php?id=${r.id}" class="btn btn-sm btn-info" title="Ver Detalles"><i class="fa-solid fa-eye"></i></a>
                <a href="ruta-editar.php?id=${r.id}" class="btn btn-sm btn-outline-light" title="Editar"><i class="fa-solid fa-pencil"></i></a>
            `;

            if (esActiva) {
                acciones += botonActivarHtml + botonArchivarHtml;
            } else {
                // Para rutas archivadas, podríamos añadir un botón para reubicar stock en el futuro
                acciones += `<button class="btn btn-sm btn-outline-success" title="Reubicar Stock (Próximamente)"><i class="fa-solid fa-truck-ramp-box"></i></button>`;
            }

            let equipo = [];
            if (r.coordinador_nombre) equipo.push(`<strong>Coord:</strong> ${r.coordinador_nombre}`);
            if (r.doctor_nombre) equipo.push(`<strong>Doctor:</strong> ${r.doctor_nombre}`);
            if (r.chofer_nombre) equipo.push(`<strong>Chofer:</strong> ${r.chofer_nombre}`);
            const equipoHtml = equipo.length > 0 ? `<div class="equipo-lista">${equipo.join('<br>')}</div>` : '<span class="text-white-50">Sin asignar</span>';

            let fila = `
                <tr>
                    <td><strong>${r.nombre_ruta}</strong></td>
                    <td>${equipoHtml}</td>
                    <td class="text-center">${r.total_jornadas}</td>
                    <td>${formatearFecha(r.fecha_creacion)}</td>
                    ${esActiva ? `<td class="text-center">${estadoHtml}</td>` : ''}
                    <td><div class="d-flex gap-2">${acciones}</div></td>
                </tr>`;
            tablaBody.innerHTML += fila;
        });
    }

    window.cambiarEstadoRuta = function(rutaId) {
        const formData = new FormData();
        formData.append('action', 'cambiar_estado_ruta');
        formData.append('ruta_id', rutaId);
        formData.append('csrf_token', csrfToken);
        fetch('/api/rutas_ajax.php', { method: 'POST', body: formData })
        .then(res => res.json())
        .then(data => {
            if(data.success){
                Swal.fire({ toast: true, position: 'top-end', icon: 'success', title: data.message, showConfirmButton: false, timer: 2000 });
                cargarRutasAdmin();
            } else {
                Swal.fire('Error', data.message, 'error');
            }
        });
    }

    window.archivarRuta = function(rutaId) {
        Swal.fire({
            title: '¿Estás seguro?',
            text: "Archivar una ruta la moverá al historial y la desactivará. No podrás revertir esto fácilmente.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Sí, ¡archivar!',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                const formData = new FormData();
                formData.append('action', 'archivar_ruta');
                formData.append('ruta_id', rutaId);
                formData.append('csrf_token', csrfToken);
                fetch('/api/rutas_ajax.php', { method: 'POST', body: formData })
                .then(res => res.json())
                .then(data => {
                    if(data.success){
                        Swal.fire('¡Archivada!', data.message, 'success');
                        cargarRutasAdmin();
                    } else {
                        Swal.fire('Error', data.message, 'error');
                    }
                });
            }
        })
    }

    cargarRutasAdmin();
});
</script>