<?php
require_once 'includes/seguridad.php'; 
$page_title = 'Editar Ruta de Viaje';
include_once 'templates/header.php';

if (!puede('gestionar_rutas_admin')) {
    echo "<main class='ami-content'><div class='info-card'><h1>Acceso Denegado</h1></div></main>";
    include_once 'templates/footer.php';
    exit();
}

$ruta_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$ruta_id) {
    header('Location: rutas-admin.php');
    exit();
}

// Cargar todo el personal para los selectores
$coordinadores = $conn->query("SELECT id, nombre FROM usuarios WHERE rol_id IN (SELECT id FROM roles WHERE clave = 'coordinador') AND estado = 1 ORDER BY nombre ASC")->fetchAll(PDO::FETCH_ASSOC);
$doctores = $conn->query("SELECT id, nombre FROM usuarios WHERE rol_id IN (SELECT id FROM roles WHERE clave = 'doctor') AND estado = 1 ORDER BY nombre ASC")->fetchAll(PDO::FETCH_ASSOC);
$choferes = $conn->query("SELECT id, nombre FROM usuarios WHERE rol_id IN (SELECT id FROM roles WHERE clave = 'chofer') AND estado = 1 ORDER BY nombre ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

<style>
    .jornada-card {
        background: rgba(255, 255, 255, 0.05);
        border: 1px solid var(--border-color);
        border-radius: 15px;
        margin-bottom: 1.5rem;
        padding: 1.5rem;
    }
</style>

<div class="main-header">
    <div>
        <a href="rutas-admin.php" class="btn btn-outline-light mb-2"><i class="fa-solid fa-arrow-left"></i> Volver al Listado</a>
        <h1 id="main-title">Editando Ruta...</h1>
    </div>
</div>

<form id="formEditarRuta">
    <input type="hidden" name="ruta_id" value="<?php echo $ruta_id; ?>">
    <div class="info-card mb-4">
        <h4>1. Datos Generales y Personal de la Ruta</h4>
        <hr>
        <div class="row">
            <div class="col-md-12 ami-form-group mb-3">
                <label class="ami-form-label" for="nombre_ruta">Nombre de la Ruta</label>
                <input type="text" id="nombre_ruta" name="nombre_ruta" class="ami-form-control" required>
            </div>
             <div class="col-md-4 ami-form-group mb-3">
                <label class="ami-form-label" for="coordinador_id">Coordinador de Campo</label>
                <select name="coordinador_id" id="coordinador_id" class="ami-form-control form-select">
                    <option value="">Sin asignar</option>
                    <?php foreach ($coordinadores as $coordinador): ?>
                        <option value="<?php echo $coordinador['id']; ?>"><?php echo htmlspecialchars($coordinador['nombre']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-4 ami-form-group mb-3">
                <label class="ami-form-label" for="doctor_id">Doctor Asignado</label>
                <select name="doctor_id" id="doctor_id" class="ami-form-control form-select">
                    <option value="">Sin asignar</option>
                    <?php foreach ($doctores as $doctor): ?>
                        <option value="<?php echo $doctor['id']; ?>"><?php echo htmlspecialchars($doctor['nombre']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-4 ami-form-group mb-3">
                <label class="ami-form-label" for="chofer_id">Chofer Asignado</label>
                <select name="chofer_id" id="chofer_id" class="ami-form-control form-select">
                    <option value="">Sin asignar</option>
                    <?php foreach ($choferes as $chofer): ?>
                        <option value="<?php echo $chofer['id']; ?>"><?php echo htmlspecialchars($chofer['nombre']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>
    </div>

    <div class="info-card">
        <h4>2. Jornadas (Ciudades y Fechas)</h4>
        <hr>
        <div id="jornadas-container"></div>
        <button type="button" class="btn btn-outline-success mt-3" id="btn-add-jornada"><i class="fa-solid fa-plus"></i> Agregar Jornada</button>
    </div>

    <div class="mt-4">
        <button type="submit" class="btn-add-new btn-lg"><i class="fa-solid fa-save"></i> Guardar Cambios</button>
    </div>
</form>

<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://npmcdn.com/flatpickr/dist/l10n/es.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const rutaId = <?php echo $ruta_id; ?>;
    let jornadaCounter = 0;
    const csrfToken = '<?php echo $_SESSION['csrf_token']; ?>';

    function inicializarDatepicker(selector) {
        flatpickr(selector, {
            altInput: true, altFormat: "d/m/Y", dateFormat: "Y-m-d", "locale": "es"
        });
    }

    function agregarJornada(jornada = null) {
        jornadaCounter++;
        const container = document.getElementById('jornadas-container');
        const ciudad = jornada ? jornada.ciudad_nombre : '';
        const fecha = jornada ? jornada.fecha_jornada : '';
        const jornadaIdReal = jornada ? jornada.id : 'new_' + jornadaCounter;

        const jornadaHtml = `
            <div class="jornada-card" id="jornada-card-${jornadaCounter}" data-jornada-id-real="${jornadaIdReal}">
                <input type="hidden" name="jornadas[${jornadaCounter}][id]" value="${jornadaIdReal}">
                <div class="row align-items-center">
                    <div class="col-md-5"><input type="text" name="jornadas[${jornadaCounter}][ciudad]" class="ami-form-control" placeholder="Nombre de la Ciudad" value="${ciudad}" required></div>
                    <div class="col-md-5"><input type="text" name="jornadas[${jornadaCounter}][fecha]" class="ami-form-control datepicker" placeholder="Seleccionar fecha..." value="${fecha}" required></div>
                    <div class="col-md-2 text-end"><button type="button" class="btn btn-danger" onclick="this.closest('.jornada-card').remove()">Eliminar</button></div>
                </div>
            </div>`;
        container.insertAdjacentHTML('beforeend', jornadaHtml);
        inicializarDatepicker(`#jornada-card-${jornadaCounter} .datepicker`);
    }

    async function cargarDatosRuta() {
        try {
            const response = await fetch(`/api/rutas_ajax.php?action=get_ruta_for_edit&id=${rutaId}`);
            const data = await response.json();

            if (data.success) {
                const ruta = data.data;
                document.getElementById('main-title').textContent = 'Editando: ' + ruta.nombre_ruta;
                document.getElementById('nombre_ruta').value = ruta.nombre_ruta;
                document.getElementById('coordinador_id').value = ruta.coordinador_id || '';
                document.getElementById('doctor_id').value = ruta.doctor_id || '';
                document.getElementById('chofer_id').value = ruta.chofer_id || '';

                if (ruta.jornadas.length > 0) {
                    ruta.jornadas.forEach(jornada => agregarJornada(jornada));
                }
            } else {
                Swal.fire('Error', data.message, 'error').then(() => window.location.href = 'rutas-admin.php');
            }
        } catch (error) {
            Swal.fire('Error de Conexión', 'No se pudieron cargar los datos de la ruta.', 'error');
        }
    }

    document.getElementById('btn-add-jornada').addEventListener('click', () => agregarJornada(null));
    
    document.getElementById('formEditarRuta').addEventListener('submit', function(e) {
        e.preventDefault();
        Swal.fire({ title: 'Actualizando...', allowOutsideClick: false, didOpen: () => Swal.showLoading() });

        const formData = new FormData(this);
        formData.append('action', 'editar_ruta_completa');
        formData.append('csrf_token', csrfToken);

        fetch('/api/rutas_ajax.php', { method: 'POST', body: formData })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                Swal.fire('¡Actualizado!', data.message, 'success').then(() => { window.location.href = 'rutas-admin.php'; });
            } else {
                Swal.fire('Error', data.message, 'error');
            }
        });
    });

    cargarDatosRuta();
});
</script>

<?php include_once 'templates/footer.php'; ?>