<?php
require_once 'includes/seguridad.php'; 
if (!puede('gestionar_nomina')) {
    header('Location: inicio.php?error=acceso_denegado');
    exit();
}

$page_title = 'Reportes de Comisiones';
include_once 'templates/header.php';
?>

<style>
    .report-card {
        max-width: 800px;
        margin: 2rem auto;
    }
    .form-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
        gap: 1.5rem;
        align-items: end;
    }
    .btn-quincena {
        font-size: 1.1rem;
        padding: 0.75rem;
        font-weight: 600;
    }
    /* Estilo para el input de la tasa */
    .input-group-text-custom {
        background-color: #343a40;
        border: 1px solid #6c757d;
        color: #fff;
    }
</style>

<div class="main-header">
    <h1><?php echo $page_title; ?></h1>
    <p class="lead">Seleccione el período y genere el reporte de comisiones por operador.</p>
</div>

<div class="info-card report-card">
    <h5 class="detalle-titulo"><i class="fa-solid fa-calendar-alt me-2"></i>Seleccionar Período y Tasa</h5>
    <div class="form-grid">
        <div>
            <label for="select-mes" class="ami-form-label">Mes</label>
            <select id="select-mes" class="form-select">
                <?php
                $meses_es = ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'];
                for ($i = 1; $i <= 12; $i++) {
                    $monthNum = str_pad((string)$i, 2, "0", STR_PAD_LEFT);
                    $nombre_mes_es = $meses_es[$i - 1];
                    $selected = (date('n') == $i) ? 'selected' : '';
                    echo "<option value=\"{$monthNum}\" {$selected}>{$nombre_mes_es}</option>";
                }
                ?>
            </select>
        </div>
        <div>
            <label for="select-anio" class="ami-form-label">Año</label>
            <select id="select-anio" class="form-select">
                <?php
                $currentYear = date('Y');
                for ($i = $currentYear; $i >= $currentYear - 5; $i--) {
                    echo "<option value=\"{$i}\">{$i}</option>";
                }
                ?>
            </select>
        </div>
        <div>
            <label for="tasa-cambio" class="ami-form-label">Tasa del Día (Bs. / USD)</label>
            <div class="input-group">
                <span class="input-group-text input-group-text-custom">Bs.</span>
                <input type="number" id="tasa-cambio" class="form-control" placeholder="Ej: 37.50" step="0.01" required>
            </div>
        </div>
    </div>
    
    <hr style="border-color: var(--border-color); margin: 2rem 0;">

    <div class="row g-3">
        <div class="col-md-6">
            <button class="btn btn-primary w-100 btn-quincena" onclick="generarReporte(1)">
                <i class="fa-solid fa-file-pdf me-2"></i>Generar 1ra Quincena (1-15)
            </button>
        </div>
        <div class="col-md-6">
            <button class="btn btn-success w-100 btn-quincena" onclick="generarReporte(2)">
                <i class="fa-solid fa-file-pdf me-2"></i>Generar 2da Quincena (16-Fin)
            </button>
        </div>
    </div>
</div>

<script>
function generarReporte(quincena) {
    const mes = document.getElementById('select-mes').value;
    const anio = document.getElementById('select-anio').value;
    const tasa = document.getElementById('tasa-cambio').value;

    if (!tasa || parseFloat(tasa) <= 0) {
        Swal.fire('Atención', 'Por favor, ingrese una tasa de cambio válida.', 'warning');
        return;
    }
    
    let fecha_inicio, fecha_fin;

    if (quincena === 1) {
        fecha_inicio = `${anio}-${mes}-01`;
        fecha_fin = `${anio}-${mes}-15`;
    } else {
        fecha_inicio = `${anio}-${mes}-16`;
        const ultimoDia = new Date(anio, mes, 0).getDate();
        fecha_fin = `${anio}-${mes}-${ultimoDia}`;
    }

    Swal.fire({
        title: 'Generando Reporte...',
        html: `Creando el PDF para el período del <b>${fecha_inicio}</b> al <b>${fecha_fin}</b>. Por favor, espere.`,
        allowOutsideClick: false,
        didOpen: () => { Swal.showLoading(); }
    });

    const url = `/api/reportes_ajax.php?fecha_inicio=${fecha_inicio}&fecha_fin=${fecha_fin}&tasa_bsd=${tasa}`;

    fetch(url)
        .then(response => {
            if (!response.ok) {
                return response.json().then(errorData => {
                    throw new Error(errorData.message || `Error del servidor: ${response.statusText}`);
                });
            }
            if (response.headers.get("Content-Type") !== "application/pdf") {
                 return response.text().then(text => {
                     throw new Error('El servidor no generó un PDF. Respuesta: ' + text);
                 });
            }
            return response.blob();
        })
        .then(blob => {
            Swal.close();
            const url = window.URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.style.display = 'none';
            a.href = url;
            a.download = `Reporte_Comisiones_${fecha_inicio}_al_${fecha_fin}.pdf`;
            document.body.appendChild(a);
            a.click();
            window.URL.revokeObjectURL(url);
            a.remove();
        })
        .catch(error => {
            Swal.fire({
                icon: 'error',
                title: 'Error al Generar Reporte',
                text: error.message
            });
        });
}
</script>

<?php 
include_once 'templates/footer.php'; 
?>