<?php
require_once 'includes/seguridad.php';
if (!puede('ver_afiliaciones')) {
    header('Location: inicio.php?error=acceso_denegado');
    exit();
}
$page_title = 'Historial de Pagos';
include_once 'templates/header.php';
?>

<style>
    .text-muted {
   opacity: 1;
   color: rgba(255, 255, 255, 0.75)!important;
}
</style>
<div class="main-header">
    <h1><i class="fa-solid fa-receipt text-primary"></i> <?php echo $page_title; ?></h1>
    <h2 id="nombre-titular-header" class="text-muted">Cargando...</h2>
</div>

<div class="info-card">
    <div class="table-responsive">
        <table class="ami-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Fecha de Pago</th>
                    <th>Monto Pagado</th>
                    <th>Método</th>
                    <th>Referencia</th>
                    <th>Período Cubierto</th>
                    <th>Plan Pagado</th>
                    <th>Registrado Por</th>
                    <th>Fecha de Registro</th>
                </tr>
            </thead>
            <tbody id="historial-pagos-body">
                </tbody>
        </table>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const tablaBody = document.getElementById('historial-pagos-body');
    const headerTitular = document.getElementById('nombre-titular-header');

    const formatDate = (dateString) => {
        if (!dateString) return 'N/A';
        return new Date(dateString + 'T00:00:00').toLocaleDateString('es-ES');
    };

    const cargarHistorial = (afiliacionId) => {
        tablaBody.innerHTML = `<tr><td colspan="9" class="text-center">Cargando historial...</td></tr>`;

        fetch(`/api/pagos_detalles_ajax.php?action=cargar_historial&id=${afiliacionId}`)
            .then(res => res.json())
            .then(data => {
                tablaBody.innerHTML = '';
                if (data.success) {
                    const afiliacion = data.data.afiliacion;
                    const historial = data.data.historial;

                    const nombreMostrado = afiliacion.tipo_contrato === 'Empresarial' ? afiliacion.nombre_empresa : `${afiliacion.nombre_titular} ${afiliacion.apellido_titular}`;
                    headerTitular.textContent = nombreMostrado;
                    document.title = `Historial de ${nombreMostrado}`;

                    if (historial.length === 0) {
                        tablaBody.innerHTML = `<tr><td colspan="9" class="text-center">No se han registrado pagos para esta afiliación.</td></tr>`;
                        return;
                    }

                    let contador = 1;
                    historial.forEach(pago => {
                        // MODIFICADO: Lógica para mostrar el monto en Bs. si existe
                        let montoHtml = `$${parseFloat(pago.monto_pagado).toFixed(2)}`;
                        if (pago.monto_bs && parseFloat(pago.monto_bs) > 0) {
                            montoHtml += `<br><small class="text-muted">${new Intl.NumberFormat('es-VE').format(pago.monto_bs)} Bs.</small>`;
                        }

                        const fila = `
                            <tr>
                                <td>${contador++}</td>
                                <td><strong>${formatDate(pago.fecha_pago)}</strong></td>
                                <td>${montoHtml}</td>
                                <td>${pago.metodo_pago || 'N/A'}</td>
                                <td>${pago.referencia || 'N/A'}</td>
                                <td>${formatDate(pago.periodo_cubierto_desde)} al ${formatDate(pago.periodo_cubierto_hasta)}</td>
                                <td>${pago.nombre_plan || 'N/A'}</td>
                                <td>${pago.nombre_usuario_registro || 'Desconocido'}</td>
                                <td>${new Date(pago.fecha_registro).toLocaleString('es-ES')}</td>
                            </tr>
                        `;
                        tablaBody.innerHTML += fila;
                    });

                } else {
                    Swal.fire('Error', data.message, 'error');
                    tablaBody.innerHTML = `<tr><td colspan="9" class="text-center text-danger">${data.message}</td></tr>`;
                }
            })
            .catch(error => {
                console.error('Error en fetch:', error);
                Swal.fire('Error de Conexión', 'No se pudo comunicar con el servidor.', 'error');
                tablaBody.innerHTML = `<tr><td colspan="9" class="text-center text-danger">Error de conexión.</td></tr>`;
            });
    };

    const urlParams = new URLSearchParams(window.location.search);
    const afiliacionId = urlParams.get('id');

    if (afiliacionId) {
        cargarHistorial(afiliacionId);
    } else {
        headerTitular.textContent = 'ID de Afiliación no especificado';
        tablaBody.innerHTML = '<tr><td colspan="9" class="text-center text-danger">No se proporcionó un ID de afiliación en la URL.</td></tr>';
    }
});
</script>

<?php include_once 'templates/footer.php'; ?>