<?php
require_once 'includes/seguridad.php';
// Título dinámico según el rol
$page_title = ($_SESSION['rol_clave'] === 'superadmin') ? 'Todas las Rutas - Supervisión' : 'Mis Rutas Asignadas';

// MANEJO DE ERRORES DE SEGURIDAD
$error_message = '';
$error_type = '';
if (isset($_GET['error'])) {
    $error_code = $_GET['error'];
    $jornada_id = filter_input(INPUT_GET, 'jornada_id', FILTER_VALIDATE_INT);
    switch($error_code) {
        case 'acceso_denegado':
            $error_message = 'Intento de acceso denegado: No tienes permisos para ver esa jornada.';
            $error_type = 'danger';
            registrar_accion('intento_acceso_denegado', "Intento de acceder a jornada sin permisos. Jornada ID: " . ($jornada_id ?: 'desconocido'));
            break;
        case 'fecha_incorrecta':
            $error_message = 'Acceso fuera de horario: Solo puedes gestionar jornadas en el día correspondiente.';
            $error_type = 'warning';
            registrar_accion('acceso_fuera_fecha', "Intento de acceder a jornada fuera de la fecha permitida. Jornada ID: " . ($jornada_id ?: 'desconocido'));
            break;
        case 'jornada_no_encontrada':
            $error_message = 'La jornada solicitada no existe o ha sido eliminada.';
            $error_type = 'danger';
            registrar_accion('acceso_jornada_inexistente', "Intento de acceder a jornada inexistente. Jornada ID: " . ($jornada_id ?: 'desconocido'));
            break;
        default:
            $error_message = 'Error de acceso no especificado.';
            $error_type = 'warning';
            registrar_accion('error_acceso_general', "Error de acceso general. Código: {$error_code}");
            break;
    }
}

include_once 'templates/header.php';

if (!puede('ver_rutas_coordinador')) {
    echo "<main class='ami-content'><div class='info-card'><h1>Acceso Denegado</h1></div></main>";
    include_once 'templates/footer.php';
    exit();
}
?>

<style>
.ruta-card { background: var(--card-bg); border-radius: 15px; padding: 1.5rem; margin-bottom: 1.5rem; border: 1px solid var(--border-color); backdrop-filter: var(--blur-effect); -webkit-backdrop-filter: var(--blur-effect); }
.jornada-item { padding: 1rem 1.5rem; border-radius: 10px; margin-bottom: 0.75rem; background-color: rgba(0,0,0,0.25); display: flex; justify-content: space-between; align-items: center; border: 1px solid var(--border-color); text-decoration: none; color: var(--light-text); transition: all 0.3s ease; }
.jornada-item strong { font-size: 1.1rem; }
.jornada-item.disabled { opacity: 0.6; cursor: not-allowed; background-color: rgba(0,0,0,0.1); }
.jornada-item.active { border-color: var(--primary-color); background-color: var(--primary-color); color: var(--dark-text); font-weight: bold; }
.jornada-item.active:hover { background-color: var(--hover-color); transform: scale(1.02); }
.jornada-item.status-completada { background-color: rgba(25, 135, 84, 0.2); border-color: rgba(25, 135, 84, 0.8); opacity: 0.7; cursor: default; }
.jornada-status-badge { display: flex; align-items: center; gap: 8px; font-size: 0.9rem; font-weight: 500; }
.supervisor-info { background-color: rgba(0, 123, 255, 0.1); border-left: 4px solid var(--primary-color); padding: 0.5rem 1rem; margin-bottom: 1rem; border-radius: 0 8px 8px 0; }
.progreso-jornada { font-size: 0.85rem; color: var(--light-text); margin-top: 0.3rem; }
.jornada-item.supervisor { background-color: rgba(0, 123, 255, 0.15); border-color: rgba(0, 123, 255, 0.3); }
.jornada-item.supervisor:hover { background-color: rgba(0, 123, 255, 0.25); transform: scale(1.01); }
.error-alert { margin-bottom: 1.5rem; padding: 1rem 1.5rem; border-radius: 10px; border: 1px solid; display: flex; align-items: center; gap: 10px; }
.error-alert.alert-danger { background-color: rgba(220, 53, 69, 0.1); border-color: rgba(220, 53, 69, 0.3); color: #f8d7da; }
.error-alert.alert-warning { background-color: rgba(255, 193, 7, 0.1); border-color: rgba(255, 193, 7, 0.3); color: #fff3cd; }
.error-alert i { font-size: 1.2rem; }

/* --- NUEVOS ESTILOS PARA EL ACORDEÓN --- */
.accordion-item { background-color: transparent; border: 1px solid var(--border-color); border-radius: 10px !important; margin-bottom: 0.5rem; }
.accordion-header { border-radius: 10px !important; }
.accordion-button { background: rgba(0,0,0,0.2); color: var(--light-text); font-weight: 500; border-radius: 10px !important; }
.accordion-button:not(.collapsed) { background-color: var(--primary-color); color: var(--dark-text); box-shadow: none; }
.accordion-button:focus { box-shadow: none; border-color: var(--primary-color); }
.accordion-button::after { filter: invert(1) grayscale(100%) brightness(200%); }
.accordion-button:not(.collapsed)::after { filter: invert(1) grayscale(100%) brightness(0%); }
.accordion-body { padding: 1rem; }
.jornada-group-title { font-size: 1.2rem; font-weight: 500; color: var(--light-text); margin-bottom: 1rem; border-bottom: 2px solid var(--border-color); padding-bottom: 0.5rem; }
</style>

<div class="main-header">
    <h1><?php echo $page_title; ?></h1>
    <?php if ($_SESSION['rol_clave'] === 'superadmin'): ?>
    <div class="supervisor-info"><i class="fa-solid fa-user-shield"></i> <strong>Modo Supervisión:</strong> Puedes acceder a todas las jornadas de cualquier coordinador en cualquier fecha.</div>
    <?php endif; ?>
</div>

<?php if (!empty($error_message)): ?>
<div class="error-alert alert-<?php echo $error_type; ?>">
    <i class="fa-solid fa-<?php echo $error_type === 'danger' ? 'exclamation-triangle' : 'exclamation-circle'; ?>"></i>
    <div><strong>Error de Acceso:</strong><br><?php echo htmlspecialchars($error_message); ?></div>
</div>
<?php endif; ?>

<div id="rutas-container"><div class="info-card text-center"><p>Cargando tus rutas asignadas...</p></div></div>

<?php include_once 'templates/footer.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const esSuperadmin = <?php echo json_encode($_SESSION['rol_clave'] === 'superadmin'); ?>;

    function generarHtmlJornada(jornada, estado_jornada) {
        let enlace, claseCss, tooltip, statusBadge;
        const fechaFormato = new Date(jornada.fecha_jornada + 'T00:00:00').toLocaleDateString('es-ES', { day: '2-digit', month: 'long', year: 'numeric' });

        if (esSuperadmin) {
            enlace = `href="jornada-coordinador.php?id=${jornada.id}"`;
            claseCss = 'supervisor';
            tooltip = 'Modo supervisión - Click para ver/gestionar esta jornada';
            let progresoInfo = (jornada.total_pacientes !== undefined) ? `<div class="progreso-jornada">${jornada.pacientes_atendidos || 0}/${jornada.total_pacientes} atendidos (${jornada.progreso || 0}%)</div>` : '';
            statusBadge = `<div class="jornada-status-badge"><i class="fa-solid fa-user-shield"></i> Supervisar ${progresoInfo}</div>`;
        } else {
            switch(estado_jornada) {
                case 'Completada':
                    enlace = 'href="#" onclick="return false;"';
                    claseCss = 'status-completada disabled';
                    tooltip = 'Esta jornada ya finalizó y no puede ser modificada.';
                    statusBadge = `<div class="jornada-status-badge text-success"><i class="fa-solid fa-check-circle"></i> Completada</div>`;
                    break;
                case 'En Curso':
                    enlace = `href="jornada-coordinador.php?id=${jornada.id}"`;
                    claseCss = 'active';
                    tooltip = 'Jornada activa. Click para gestionar.';
                    statusBadge = `<div class="jornada-status-badge">Gestionar Jornada <i class="fa-solid fa-arrow-right"></i></div>`;
                    break;
                default: // Planificada
                    enlace = 'href="#" onclick="return false;"';
                    claseCss = 'disabled';
                    tooltip = 'Esta jornada se activará en su fecha correspondiente.';
                    statusBadge = `<div class="jornada-status-badge"><i class="fa-solid fa-lock"></i> Bloqueada</div>`;
                    break;
            }
        }
        return `<a ${enlace} class="jornada-item ${claseCss}" title="${tooltip}"><div><strong>${jornada.ciudad_nombre}</strong><br><small>${fechaFormato}</small></div>${statusBadge}</a>`;
    }

    function cargarRutasCoordinador() {
        const action = esSuperadmin ? 'get_todas_rutas_superadmin' : 'get_rutas_coordinador';
        fetch(`/api/rutas_ajax.php?action=${action}`)
        .then(res => res.json())
        .then(data => {
            const container = document.getElementById('rutas-container');
            container.innerHTML = '';

            if (!data.success) { container.innerHTML = `<div class="info-card text-center text-danger">${data.message}</div>`; return; }
            if (data.data.length === 0) {
                const mensaje = esSuperadmin ? 'No hay rutas registradas en el sistema.' : 'No tienes rutas de viaje asignadas en este momento.';
                container.innerHTML = `<div class="info-card text-center"><p>${mensaje}</p></div>`;
                return;
            }

            data.data.forEach(ruta => {
                let jornadasHtml = '<p class="text-white-50 small">Esta ruta no tiene jornadas programadas.</p>';
                if (ruta.jornadas.length > 0) {
                    const hoyStr = new Date().toLocaleDateString('en-CA', {timeZone: 'America/Caracas'});
                    const grupos = { enCurso: [], planificadas: [], completadas: [] };

                    ruta.jornadas.forEach(jornada => {
                        if (jornada.fecha_jornada < hoyStr) grupos.completadas.push(jornada);
                        else if (jornada.fecha_jornada === hoyStr) grupos.enCurso.push(jornada);
                        else grupos.planificadas.push(jornada);
                    });

                    grupos.planificadas.sort((a, b) => new Date(a.fecha_jornada) - new Date(b.fecha_jornada));
                    grupos.completadas.sort((a, b) => new Date(b.fecha_jornada) - new Date(a.fecha_jornada));

                    let accordionHtml = '';
                    const accordionId = `accordion-ruta-${ruta.id}`;

                    if (grupos.enCurso.length > 0) {
                        accordionHtml += `<div class="jornada-group-title">Jornada de Hoy</div>`;
                        accordionHtml += grupos.enCurso.map(j => generarHtmlJornada(j, 'En Curso')).join('');
                    }
                    
                    accordionHtml += `<div class="accordion" id="${accordionId}">`;
                    if (grupos.planificadas.length > 0) {
                        const itemsHtml = grupos.planificadas.map(j => generarHtmlJornada(j, 'Planificada')).join('');
                        accordionHtml += `<div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-planificadas-${ruta.id}">Jornadas Planificadas <span class="badge bg-primary ms-2">${grupos.planificadas.length}</span></button></h2><div id="collapse-planificadas-${ruta.id}" class="accordion-collapse collapse" data-bs-parent="#${accordionId}"><div class="accordion-body">${itemsHtml}</div></div></div>`;
                    }
                    if (grupos.completadas.length > 0) {
                        const itemsHtml = grupos.completadas.map(j => generarHtmlJornada(j, 'Completada')).join('');
                        accordionHtml += `<div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-completadas-${ruta.id}">Jornadas Completadas <span class="badge bg-secondary ms-2">${grupos.completadas.length}</span></button></h2><div id="collapse-completadas-${ruta.id}" class="accordion-collapse collapse" data-bs-parent="#${accordionId}"><div class="accordion-body">${itemsHtml}</div></div></div>`;
                    }
                    accordionHtml += `</div>`;
                    jornadasHtml = accordionHtml;
                }

                let coordinadorInfo = (esSuperadmin && ruta.coordinador_nombre) ? `<div class="supervisor-info"><i class="fa-solid fa-user"></i> <strong>Coordinador:</strong> ${ruta.coordinador_nombre}</div>` : '';
                const rutaCardHtml = `<div class="ruta-card"><h3>${ruta.nombre_ruta}</h3>${coordinadorInfo}<hr style="border-color: var(--border-color); margin: 1rem 0;">${jornadasHtml}</div>`;
                container.innerHTML += rutaCardHtml;
            });
        })
        .catch(error => {
            console.error('Error al cargar rutas:', error);
            document.getElementById('rutas-container').innerHTML = '<div class="info-card text-center text-danger">Error de conexión al cargar las rutas.</div>';
        });
    }

    const errorAlert = document.querySelector('.error-alert');
    if (errorAlert) {
        setTimeout(() => {
            errorAlert.style.transition = 'opacity 0.5s ease';
            errorAlert.style.opacity = '0';
            setTimeout(() => errorAlert.remove(), 500);
        }, 8000);
    }

    cargarRutasCoordinador();
});
</script>