<?php
require_once __DIR__ . '/../../includes/bootstrap.php';

// --- EL GUARDIÁN ---
if (!isset($_SESSION['user_id'])) {
    header('Location: /login.php');
    exit();
}

$session_id = session_id();
$usuario_id = $_SESSION['user_id'];
$ip_address = $_SERVER['REMOTE_ADDR'];
$user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'N/A';
$fecha_actual_vzla = date('Y-m-d H:i:s');

try {
    // --- LÓGICA DE VALIDACIÓN DE SESIÓN ÚNICA ---
    $stmt_check = $conn->prepare("SELECT session_id, estado, modulo_actual FROM sesiones_activas WHERE usuario_id = ? AND is_active = 1 LIMIT 1");
    $stmt_check->execute([$usuario_id]);
    $sesion_activa_db = $stmt_check->fetch(PDO::FETCH_ASSOC);

    if (!$sesion_activa_db || $sesion_activa_db['session_id'] !== $session_id) {
        $detalle_log = 'Logout forzado: Se detectó una nueva sesión en otro dispositivo.';
        registrar_accion('logout_forzado_sesion_unica', $detalle_log);

        session_unset();
        session_destroy();
        header('Location: /login.php?mensaje=sesion_reemplazada');
        exit();
    }
    
    if ($sesion_activa_db['estado'] === 'cerrada') {
        registrar_accion('logout_remoto', 'Sesión cerrada remotamente por un administrador.');
        session_unset();
        session_destroy();
        header('Location: /login.php?mensaje=sesion_cerrada');
        exit();
    }
    
    // Validar tiempo de inactividad
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > 3600)) { // 60 minutos
        $stmt_expire = $conn->prepare("UPDATE sesiones_activas SET estado = 'expirada', is_active = 0 WHERE session_id = ?");
        $stmt_expire->execute([$session_id]);
        registrar_accion('logout_automatico', 'Sesión expirada por inactividad (60 minutos)');
        
        session_unset();
        session_destroy();
        header('Location: /login.php?mensaje=sesion_expirada');
        exit();
    }
    $_SESSION['last_activity'] = time();

    // Actualizar actividad de la sesión
    $archivo_actual = basename($_SERVER['PHP_SELF'], ".php");
    $es_ajax = (strpos($archivo_actual, '_ajax') !== false) || (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest');
    
    $modulo_a_registrar = $es_ajax ? ($sesion_activa_db['modulo_actual'] ?? $archivo_actual) : $archivo_actual;

    $stmt_update_activity = $conn->prepare("UPDATE sesiones_activas SET last_activity = ?, modulo_actual = ? WHERE session_id = ?");
    $stmt_update_activity->execute([$fecha_actual_vzla, $modulo_a_registrar, $session_id]);

    if (!$es_ajax) {
        registrar_accion('vista_modulo', "Vio el módulo: " . ucfirst($archivo_actual));
    }
    
} catch (PDOException $e) {
    error_log("Error en monitoreo/auditoría (seguridad.php): " . $e->getMessage());
}

// --- FUNCIÓN DE PERMISOS ---
function puede($permiso_clave) {
    if (isset($_SESSION['rol_clave']) && $_SESSION['rol_clave'] === 'superadmin') return true;
    return isset($_SESSION['permisos']) && in_array($permiso_clave, $_SESSION['permisos']);
}

// --- FUNCIÓN DE BITÁCORA ---
function registrar_accion($accion, $detalle) {
    global $conn;
    if (!isset($_SESSION['user_id'])) return;
    try {
        $stmt = $conn->prepare("INSERT INTO bitacora_actividad (usuario_id, session_id, accion, detalle, ip_address, fecha) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([$_SESSION['user_id'], session_id(), $accion, $detalle, $_SERVER['REMOTE_ADDR'], date('Y-m-d H:i:s')]);
    } catch (PDOException $e) {
        error_log("Error al registrar en bitácora: " . $e->getMessage());
    }
}

// --- LÓGICA PARA LA PLANTILLA ---
$activePage = basename($_SERVER['PHP_SELF'], ".php");
$stmt_usuario = $conn->prepare("SELECT u.nombre, u.foto_perfil, r.nombre as rol_nombre, r.clave as rol_clave FROM usuarios u LEFT JOIN roles r ON u.rol_id = r.id WHERE u.id = ?");
$stmt_usuario->execute([$_SESSION['user_id']]);
$user_data = $stmt_usuario->fetch(PDO::FETCH_ASSOC);

if ($user_data) {
    $_SESSION['user_nombre'] = $user_data['nombre'];
    $_SESSION['rol_clave'] = $user_data['rol_clave'];
}

$usuario_actual = [
    'id' => $_SESSION['user_id'],
    'nombre' => $_SESSION['user_nombre'] ?? 'Usuario',
    'rol' => $user_data['rol_nombre'] ?? 'Sin rol',
    'foto_perfil' => $user_data['foto_perfil'] ?? null,
    'sedes' => $_SESSION['sedes_accesibles'] ?? [],
    'permisos' => $_SESSION['permisos'] ?? []
];

if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>