<?php
require_once 'includes/seguridad.php';
// Reemplaza 'tu_permiso_aqui' por el permiso real para esta acción
if (!puede('tu_permiso_aqui')) { 
    header('Location: inicio.php?error=acceso_denegado');
    exit();
}
$page_title = 'Importar Jornadas a Ruta';
include_once 'templates/header.php';
?>

<style>
    .upload-area { border: 2px dashed #444c56; border-radius: 10px; padding: 40px; text-align: center; transition: all .3s ease; background: #2d333b; cursor: pointer; }
    .upload-area:hover, .upload-area.dragover { border-color: var(--primary-color); background: #333942; }
    .file-info { background: #2d333b; padding: 15px; border-radius: 8px; margin-top: 15px; display: none; border: 1px solid #444c56; }
</style>

<div class="main-header">
    <h1><i class="fa-solid fa-file-import text-primary"></i> <?php echo $page_title; ?></h1>
    <p class="text-muted">Selecciona una ruta existente y sube un archivo CSV para asignarle nuevas jornadas masivamente.</p>
</div>

<div class="info-card p-4">
    <form id="form-importar-jornadas">
        <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
        
        <div class="mb-4">
            <label for="rutaSelector" class="form-label fw-bold fs-5">1. Selecciona la Ruta de Destino</label>
            <select id="rutaSelector" name="ruta_id" class="form-select form-select-lg" required>
                <option value="">Cargando rutas...</option>
            </select>
        </div>

        <div class="mb-4">
            <label class="form-label fw-bold fs-5">2. Sube el Archivo CSV con las Jornadas</label>
            <div class="upload-area" id="uploadArea">
                <i class="fa-solid fa-cloud-arrow-up fa-3x text-muted mb-3"></i>
                <h5>Arrastra tu archivo CSV aquí</h5>
                <p class="text-muted">o haz clic para seleccionar</p>
                <input type="file" id="fileInput" name="archivo_jornadas" class="d-none" accept=".csv" required>
            </div>
            <div class="file-info" id="fileInfo">
                <strong>Archivo:</strong> <span id="fileName"></span> | <strong>Tamaño:</strong> <span id="fileSize"></span>
            </div>
        </div>

        <div class="text-end">
            <button type="submit" class="btn btn-primary btn-lg px-5 py-3" id="btnImportar">
                <i class="fa-solid fa-check me-2"></i> Iniciar Importación
            </button>
        </div>
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const rutaSelector = document.getElementById('rutaSelector');
    const uploadArea = document.getElementById('uploadArea');
    const fileInput = document.getElementById('fileInput');
    const fileInfo = document.getElementById('fileInfo');
    const form = document.getElementById('form-importar-jornadas');

    // 1. Cargar las rutas activas al iniciar la página
    fetch('/api/importar_jornadas_ajax.php?action=cargar_rutas_activas')
        .then(res => res.json())
        .then(data => {
            if (data.success && data.data.length > 0) {
                rutaSelector.innerHTML = '<option value="">-- Selecciona una ruta --</option>';
                data.data.forEach(ruta => {
                    const option = new Option(ruta.nombre_ruta, ruta.id);
                    rutaSelector.add(option);
                });
            } else {
                rutaSelector.innerHTML = '<option value="">No hay rutas activas creadas</option>';
            }
        });

    // 2. Lógica para el área de carga de archivos
    uploadArea.addEventListener('click', () => fileInput.click());
    ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
        uploadArea.addEventListener(eventName, e => {
            e.preventDefault();
            e.stopPropagation();
        });
    });
    uploadArea.addEventListener('dragover', () => uploadArea.classList.add('dragover'));
    uploadArea.addEventListener('dragleave', () => uploadArea.classList.remove('dragover'));
    uploadArea.addEventListener('drop', e => {
        fileInput.files = e.dataTransfer.files;
        handleFile(fileInput.files[0]);
    });
    fileInput.addEventListener('change', e => handleFile(e.target.files[0]));

    function handleFile(file) {
        if (file) {
            fileInfo.style.display = 'block';
            document.getElementById('fileName').textContent = file.name;
            document.getElementById('fileSize').textContent = (file.size / 1024).toFixed(2) + ' KB';
        }
    }
    
    // 3. Lógica para enviar el formulario con el MANEJO DE ERRORES DETALLADO
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        const formData = new FormData(this);
        formData.append('action', 'importar_jornadas');

        Swal.fire({
            title: 'Importando...',
            text: 'Procesando el archivo, por favor espera.',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });
        
        fetch('/api/importar_jornadas_ajax.php', { method: 'POST', body: formData })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    let finalMessage = data.message;
                    // Si la respuesta incluye una lista de errores, la mostramos
                    if (data.errores && data.errores.length > 0) {
                        const errorListHtml = '<ul class="text-start mt-3" style="max-height: 200px; overflow-y: auto; list-style-type: none; padding-left: 0;">' + data.errores.map(e => `<li><small class="text-danger"><i class="fa-solid fa-times-circle me-2"></i>${e}</small></li>`).join('') + '</ul>';
                        finalMessage += '<div class="alert alert-warning mt-3"><strong>Detalles de las filas omitidas:</strong>' + errorListHtml + '</div>';
                        
                        Swal.fire({
                            title: 'Importación con Errores',
                            html: finalMessage,
                            icon: 'warning'
                        });
                    } else {
                        Swal.fire('¡Éxito!', data.message, 'success');
                    }
                    form.reset();
                    fileInfo.style.display = 'none';
                } else {
                    Swal.fire('Error', data.message, 'error');
                }
            })
            .catch(() => Swal.fire('Error de Conexión', 'No se pudo comunicar con el servidor.', 'error'));
    });
});
</script>

<?php include_once 'templates/footer.php'; ?>