<?php
require_once 'includes/seguridad.php';

if (!puede('realizar_cuadre_caja')) {
    header('Location: inicio.php?error=6');
    exit;
}

$page_title = 'Auditoría y Cuadre de Jornada';
include_once 'templates/header.php';
?>

<style>
    /* --- ESTILOS NUEVOS Y PROFESIONALES --- */
    :root {
        --ami-verde: #1abc9c;
        --ami-verde-hover: #16a085;
        --ami-azul-oscuro: #2c3e50;
        --ami-azul-medio: #34495e;
        --ami-texto-claro: #ecf0f1;
        --ami-texto-gris: #95a5a6;
        --ami-rojo: #e74c3c;
        --ami-amarillo: #f1c40f;
    }
    
    .cuadre-seccion { background-color: var(--ami-azul-oscuro); padding: 2rem; border-radius: 12px; margin-bottom: 1.5rem; border: 1px solid var(--ami-azul-medio); box-shadow: 0 4px 20px rgba(0,0,0,0.25); }
    .seccion-titulo { color: var(--ami-verde); border-bottom: 2px solid var(--ami-verde); padding-bottom: 0.75rem; margin-bottom: 1.75rem; font-size: 1.5rem; font-weight: 300; letter-spacing: 1px; }
    .seccion-titulo i { margin-right: 12px; }
    
    .resumen-linea { display: flex; justify-content: space-between; align-items: center; padding: 0.9rem 0.5rem; border-bottom: 1px solid var(--ami-azul-medio); transition: background-color 0.2s ease-in-out; }
    .resumen-linea:last-child { border-bottom: none; }
    .resumen-linea strong { color: var(--ami-texto-claro); font-size: 1.1em; }
    .resumen-linea .moneda-equivalente { color: var(--ami-texto-gris); font-size: 0.9em; margin-left: 10px; }
    
    .resumen-total { font-size: 1.4rem; font-weight: 600; color: var(--ami-verde); margin-top: 1rem; padding-top: 1rem; border-top: 2px solid var(--ami-azul-medio); }
    
    .table-pacientes th { background-color: var(--ami-azul-medio); color: var(--ami-verde); font-weight: 500; border-bottom: 2px solid var(--ami-verde) !important; }
    .medicamentos-detalle { background-color: rgba(0,0,0,0.2); font-size: 0.85em; padding: 6px 12px; border-radius: 5px; display: inline-block; margin-top: 8px; border-left: 3px solid var(--ami-verde); }
    
    .auditoria-final-box { background-color: rgba(0,0,0,0.15); border-radius: 8px; padding: 1.5rem; }
    .auditoria-final-box .resumen-linea { font-size: 1.25rem; font-weight: 300; }
    .auditoria-final-box .resumen-linea strong { font-weight: 600; }
    #saldo-brigada-nuevo { font-size: 2.2rem !important; text-shadow: 0 0 10px rgba(46, 204, 113, 0.5); }
    #saldo-brigada-nuevo.positivo { color: #2ecc71; }
    #saldo-brigada-nuevo.negativo { color: var(--ami-rojo); text-shadow: 0 0 10px rgba(231, 76, 60, 0.5); }

    .btn-outline-gestor { border-color: #566573; color: #bdc3c7; }
    .btn-outline-gestor:hover { background-color: #566573; color: white; }
</style>

<div class="main-header">
    <div class="d-flex justify-content-between align-items-center">
        <h1><i class="fa-solid fa-calculator text-primary me-2"></i><?php echo $page_title; ?></h1>
        <a href="cuadres-historicos.php" class="btn btn-outline-primary"><i class="fa-solid fa-clock-rotate-left me-2"></i>Ver Historial de Cuadres</a>
    </div>
</div>

<div class="info-card mb-4">
    <div class="row g-3">
        <div class="col-md-6"><label for="select-ruta" class="ami-form-label">1. Seleccionar Ruta</label><select id="select-ruta" class="form-select"></select></div>
        <div class="col-md-6"><label for="select-jornada" class="ami-form-label">2. Seleccionar Jornada</label><select id="select-jornada" class="form-select" disabled></select></div>
    </div>
</div>

<div id="cuadre-container" class="d-none">
    
    <div class="cuadre-seccion">
         <h5 class="seccion-titulo"><i class="fa-solid fa-sliders"></i>Parámetros del Día</h5>
         <div class="row g-3">
            <div class="col-md-4"><label class="ami-form-label">Tasa Dólar (Bs/USD)</label><input type="number" id="tasa-bs-usd" class="form-control" placeholder="Ej: 37.50" step="0.01"></div>
            <div class="col-md-4"><label class="ami-form-label">Tasa Pesos (COP/USD)</label><input type="number" id="tasa-cop-usd" class="form-control" placeholder="Ej: 4000.00" step="0.01"></div>
            <div class="col-md-4"><label class="ami-form-label">Base Inicial / Caja Chica ($)</label><input type="number" id="base-inicial" class="form-control" placeholder="0.00" value="0" step="0.01"></div>
         </div>
    </div>

    <div class="cuadre-seccion">
        <h5 class="seccion-titulo"><i class="fa-solid fa-users"></i>Detalle de Ingresos por Paciente (Sistema)</h5>
        <div class="table-responsive">
            <table class="table table-dark table-striped table-hover table-pacientes">
                <thead>
                    <tr>
                        <th style="width: 30%;">Paciente y Medicamentos</th>
                        <th>Total Venta ($)</th><th>Efectivo $</th><th>Efectivo Bs</th>
                        <th>Efectivo COP</th><th>Pago Móvil</th><th>Punto Venta</th><th>Zelle</th>
                    </tr>
                </thead>
                <tbody id="tabla-pacientes-body"></tbody>
            </table>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-7">
            <div class="cuadre-seccion h-100">
                <h5 class="seccion-titulo"><i class="fa-solid fa-chart-pie"></i>Resumen de Ingresos del Día (Sistema)</h5>
                <div id="ingresos-sistema-resumen"></div>
            </div>
        </div>
        <div class="col-lg-5">
            <div class="cuadre-seccion h-100">
                <h5 class="seccion-titulo"><i class="fa-solid fa-pills"></i>Venta en Medicamentos</h5>
                <div id="medicamentos-resumen"></div>
            </div>
        </div>
    </div>

     <div class="row">
        <div class="col-lg-6">
             <div class="cuadre-seccion">
                <h5 class="seccion-titulo"><i class="fa-solid fa-arrow-up-from-bracket"></i>Gastos de la Jornada</h5>
                <div id="lista-gastos-container" class="mb-3"></div>
                <button class="btn btn-sm btn-outline-gestor" id="btn-agregar-gasto"><i class="fa-solid fa-plus me-1"></i> Registrar Gasto</button>
            </div>
        </div>
         <div class="col-lg-6">
             <div class="cuadre-seccion">
                <h5 class="seccion-titulo"><i class="fa-solid fa-money-bill-wave"></i>Liquidaciones y Depósitos</h5>
                <div id="lista-liquidaciones-container" class="mb-3"></div>
                <button class="btn btn-sm btn-outline-gestor" id="btn-agregar-liquidacion"><i class="fa-solid fa-plus me-1"></i> Registrar Liquidación</button>
            </div>
        </div>
    </div>

    <div class="cuadre-seccion">
        <h5 class="seccion-titulo"><i class="fa-solid fa-flag-checkered"></i>Auditoría Final y Cierre de Jornada</h5>
        <div class="auditoria-final-box">
            <div class="resumen-linea"><span class="fs-5">Saldo Brigada (Pendiente de Ayer)</span><strong class="fs-5" id="saldo-brigada-anterior">$0.00</strong></div>
            <div class="resumen-linea"><span class="fs-5">Base Inicial (Caja Chica de Hoy)</span><strong class="fs-5" id="resumen-base-inicial">$0.00</strong></div>
            <div class="resumen-linea"><span class="fs-5 text-success">(+) Total Ingresos del Día</span><strong class="fs-5 text-success" id="resumen-ingresos">$0.00</strong></div>
            <div class="resumen-linea"><span class="fs-5 text-danger">(-) Total Gastos del Día</span><strong class="fs-5 text-danger" id="resumen-gastos">$0.00</strong></div>
            <div class="resumen-linea resumen-total" style="color:var(--ami-amarillo) !important; border-color:var(--ami-amarillo)"><span>TOTAL A JUSTIFICAR</span><span id="total-a-justificar">$0.00</span></div>
            <div class="resumen-linea"><span class="fs-5 text-warning">(-) Total Liquidado (Depósitos)</span><strong class="fs-5 text-warning" id="resumen-liquidado">-$0.00</strong></div>
            <div class="resumen-linea resumen-total bg-dark p-3 rounded"><span>SALDO BRIGADA NUEVO (Pendiente para Mañana)</span><span id="saldo-brigada-nuevo">$0.00</span></div>
        </div>
        <div class="mt-4"><label class="form-label">Notas del Cierre</label><textarea id="notas-cuadre" class="form-control" rows="3" placeholder="Añadir observaciones sobre el cuadre..."></textarea></div>
        <div class="d-grid mt-4"><button class="btn btn-success btn-lg" id="btn-cerrar-caja"><i class="fa-solid fa-lock me-2"></i>Cerrar y Guardar Cuadre de Caja</button></div>
    </div>
</div>

<div class="modal fade ami-modal-theme" id="modalGasto" tabindex="-1">
    <div class="modal-dialog"><div class="modal-content">
        <div class="modal-header"><h5 class="modal-title" id="modalGastoTitle">Registrar Gasto</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
        <div class="modal-body">
            <form id="formGasto">
                <input type="hidden" id="gasto_id">
                <div class="mb-3"><label class="ami-form-label">Concepto</label><input type="text" id="gasto-concepto" class="form-control" required></div>
                <div class="row">
                    <div class="col-8"><label class="ami-form-label">Monto</label><input type="number" id="gasto-monto" class="form-control" min="0" step="0.01" required></div>
                    <div class="col-4"><label class="ami-form-label">Moneda</label><select id="gasto-moneda" class="form-select" required><option value="USD">$</option><option value="VES">Bs</option><option value="COP">Cop</option></select></div>
                </div>
                <div class="mt-3"><label class="ami-form-label">Descripción (Opcional)</label><textarea id="gasto-descripcion" class="form-control" rows="2"></textarea></div>
            </form>
        </div>
        <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="button" class="btn btn-primary" id="btnGuardarGasto">Guardar</button></div>
    </div></div>
</div>

<div class="modal fade ami-modal-theme" id="modalLiquidacion" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header"><h5 class="modal-title" id="modalLiquidacionTitle">Registrar Liquidación</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
            <div class="modal-body">
                <form id="formLiquidacion">
                    <input type="hidden" id="liquidacion_id">
                    <div class="mb-3"><label class="ami-form-label">Método de Pago</label>
                        <select id="liquidacion-metodo" class="form-select" required>
                            <option value="">-- Seleccione --</option>
                            <option value="Zelle">Zelle</option><option value="Pago Móvil">Pago Móvil</option>
                            <option value="Efectivo Divisas">Efectivo Divisas</option><option value="Efectivo Bolívares">Efectivo Bolívares</option>
                            <option value="Punto de Venta">Punto de Venta</option><option value="Transferencia">Transferencia</option>
                            <option value="Otro">Otro</option>
                        </select>
                    </div>
                    <div class="mb-3"><label class="ami-form-label">Monto Liquidado ($)</label><input type="number" id="liquidacion-monto" class="form-control" min="0" step="0.01" required placeholder="Monto equivalente en USD"></div>
                    <div class="mb-3"><label class="ami-form-label">Referencia (Opcional)</label><input type="text" id="liquidacion-referencia" class="form-control"></div>
                </form>
            </div>
            <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="button" class="btn btn-primary" id="btnGuardarLiquidacion">Guardar</button></div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const csrfToken = '<?php echo $_SESSION['csrf_token']; ?>';
    const modalGasto = new bootstrap.Modal(document.getElementById('modalGasto'));
    const modalLiquidacion = new bootstrap.Modal(document.getElementById('modalLiquidacion'));
    
    // --- Selectores de elementos del DOM ---
    const selectRuta = document.getElementById('select-ruta');
    const selectJornada = document.getElementById('select-jornada');
    const cuadreContainer = document.getElementById('cuadre-container');
    const tasaBsInput = document.getElementById('tasa-bs-usd');
    const tasaCopInput = document.getElementById('tasa-cop-usd');
    const baseInicialInput = document.getElementById('base-inicial');
    const tablaPacientesBody = document.getElementById('tabla-pacientes-body');
    const ingresosContainer = document.getElementById('ingresos-sistema-resumen');
    const medicamentosContainer = document.getElementById('medicamentos-resumen');
    const gastosContainer = document.getElementById('lista-gastos-container');
    const liquidacionesContainer = document.getElementById('lista-liquidaciones-container');
    const saldoAnteriorSpan = document.getElementById('saldo-brigada-anterior');
    const resumenBaseSpan = document.getElementById('resumen-base-inicial');
    const resumenIngresosSpan = document.getElementById('resumen-ingresos');
    const resumenGastosSpan = document.getElementById('resumen-gastos');
    const totalAJustificarSpan = document.getElementById('total-a-justificar');
    const resumenLiquidadoSpan = document.getElementById('resumen-liquidado');
    const saldoNuevoSpan = document.getElementById('saldo-brigada-nuevo');

    let datosJornada = {};

    function getTasas() {
        const tasaBs = parseFloat(tasaBsInput.value) || 0;
        const tasaCop = parseFloat(tasaCopInput.value) || 0;
        if (tasaBs === 0 || tasaCop === 0) return null;
        return { bs: tasaBs, cop: tasaCop };
    }

    function cargarRutas() {
        fetch('/api/cuadre_ajax.php?action=get_rutas_para_cuadre').then(res => res.json()).then(data => {
            selectRuta.innerHTML = '<option value="">-- Seleccione una Ruta --</option>';
            if (data.success) { data.data.forEach(ruta => { selectRuta.innerHTML += `<option value="${ruta.id}">${ruta.nombre_ruta}</option>`; }); }
        });
    }

    selectRuta.addEventListener('change', function() {
        const rutaId = this.value;
        selectJornada.disabled = true;
        cuadreContainer.classList.add('d-none');
        selectJornada.innerHTML = '<option value="">-- Seleccione Ruta --</option>';
        if (!rutaId) return;
        fetch(`/api/cuadre_ajax.php?action=get_jornadas_por_ruta&ruta_id=${rutaId}`).then(res => res.json()).then(data => {
            selectJornada.innerHTML = '<option value="">-- Seleccione Jornada --</option>';
            if (data.success && data.data.length > 0) {
                data.data.forEach(jornada => {
                    const fecha = new Date(jornada.fecha_jornada + 'T00:00:00').toLocaleDateString('es-ES', { timeZone: 'UTC' });
                    selectJornada.innerHTML += `<option value="${jornada.id}">${jornada.ciudad_nombre} - ${fecha}</option>`;
                });
                selectJornada.disabled = false;
            } else { selectJornada.innerHTML = '<option value="">No hay jornadas pendientes</option>'; }
        });
    });

    selectJornada.addEventListener('change', function() {
        const jornadaId = this.value;
        if (!jornadaId) { cuadreContainer.classList.add('d-none'); return; }
        fetch(`/api/cuadre_ajax.php?action=get_datos_cuadre&jornada_id=${jornadaId}`).then(res => res.json()).then(data => {
            if (data.success) {
                datosJornada = data.data;
                renderizarCuadre();
                cuadreContainer.classList.remove('d-none');
            } else { Swal.fire('Error', data.message, 'error'); }
        });
    });
    
    [tasaBsInput, tasaCopInput, baseInicialInput].forEach(input => input.addEventListener('input', renderizarCuadre));

    function renderizarCuadre() {
        const tasas = getTasas();
        if(!tasas || !datosJornada.ingresos) { return; }
        
        tablaPacientesBody.innerHTML = '';
        (datosJornada.pacientes || []).forEach(p => {
            let medicamentosHtml = '';
            if (p.medicamentos && p.medicamentos.length > 0) {
                p.medicamentos.forEach(m => { medicamentosHtml += `<div class="medicamentos-detalle">${m.cantidad}x ${m.nombre_medicamento} - $${(parseFloat(m.cantidad) * parseFloat(m.precio)).toFixed(2)}</div>`; });
            }
            tablaPacientesBody.innerHTML += `<tr><td><strong>${p.nombre_cliente}</strong><small class="d-block text-white-50">${p.cedula_cliente || 'N/A'}</small>${medicamentosHtml}</td><td>$${parseFloat(p.total_facturado).toFixed(2)}</td><td>$${parseFloat(p.pago_divisas).toFixed(2)}</td><td>Bs ${parseFloat(p.pago_bs_efectivo).toFixed(2)}</td><td>COP ${parseFloat(p.pago_pesos).toFixed(2)}</td><td>Bs ${parseFloat(p.pago_movil).toFixed(2)}</td><td>Bs ${parseFloat(p.pago_punto).toFixed(2)}</td><td>$${parseFloat(p.pago_zelle).toFixed(2)}</td></tr>`;
        });
        
        const i = datosJornada.ingresos;
        const totalDivisas = parseFloat(i.total_divisas) || 0;
        const totalZelle = parseFloat(i.total_zelle) || 0;
        const totalBs = (parseFloat(i.total_bs_efectivo) || 0) + (parseFloat(i.total_punto) || 0) + (parseFloat(i.total_movil) || 0);
        const totalPesos = parseFloat(i.total_pesos) || 0;
        const totalMedsUSD = parseFloat(datosJornada.total_medicamentos_usd) || 0;
        const granTotalIngresosUSD = totalDivisas + totalZelle + (totalBs / tasas.bs) + (totalPesos / tasas.cop);

        ingresosContainer.innerHTML = `<div class="resumen-linea"><span>Dólares (Efectivo):</span> <strong>$${totalDivisas.toFixed(2)}</strong></div><div class="resumen-linea"><span>Zelle:</span> <strong>$${totalZelle.toFixed(2)}</strong></div><div class="resumen-linea"><span>Bolívares (Total):</span> <strong>Bs ${totalBs.toFixed(2)} <span class="moneda-equivalente">(~$${(totalBs / tasas.bs).toFixed(2)})</span></strong></div><div class="resumen-linea"><span>Pesos (Total):</span> <strong>COP ${totalPesos.toFixed(2)} <span class="moneda-equivalente">(~$${(totalPesos / tasas.cop).toFixed(2)})</span></strong></div><div class="resumen-linea resumen-total"><span>TOTAL INGRESOS (Aprox.):</span> <span data-total-ingresos="${granTotalIngresosUSD.toFixed(2)}">$${granTotalIngresosUSD.toFixed(2)}</span></div>`;
        medicamentosContainer.innerHTML = `<div class="resumen-linea resumen-total"><span>Total Venta Medicamentos:</span><span data-total-medicamentos="${totalMedsUSD.toFixed(2)}">$${totalMedsUSD.toFixed(2)}</span></div>`;
        
        renderizarGastos(tasas);
        renderizarLiquidaciones(tasas);
    }
    
    function renderizarGastos(tasas) {
        gastosContainer.innerHTML = '';
        let totalGastosUSD = 0;
        if (datosJornada.gastos && datosJornada.gastos.length > 0) {
            datosJornada.gastos.forEach(g => {
                let montoUSD = 0;
                if (g.moneda === 'USD') montoUSD = parseFloat(g.monto);
                else if (g.moneda === 'VES') montoUSD = parseFloat(g.monto) / tasas.bs;
                else if (g.moneda === 'COP') montoUSD = parseFloat(g.monto) / tasas.cop;
                totalGastosUSD += montoUSD;
                gastosContainer.innerHTML += `<div class="resumen-linea"><span>${g.concepto} <small class="text-white-50">(${g.monto} ${g.moneda})</small></span><div><strong>~$${montoUSD.toFixed(2)}</strong><button class="btn btn-sm btn-outline-light ms-2 btn-editar-gasto" data-id="${g.id}" data-concepto="${g.concepto}" data-monto="${g.monto}" data-moneda="${g.moneda}" data-descripcion="${g.descripcion || ''}"><i class="fa-solid fa-pencil"></i></button><button class="btn btn-sm btn-outline-danger" onclick="eliminarGasto(${g.id})"><i class="fa-solid fa-trash"></i></button></div></div>`;
            });
        } else {
            gastosContainer.innerHTML = '<p class="text-center text-white-50">No hay gastos registrados.</p>';
        }
        gastosContainer.innerHTML += `<div class="resumen-linea resumen-total"><span>TOTAL GASTOS (Aprox.):</span> <span data-total-gastos="${totalGastosUSD.toFixed(2)}">$${totalGastosUSD.toFixed(2)}</span></div>`;
    }

    function renderizarLiquidaciones(tasas) {
        liquidacionesContainer.innerHTML = '';
        let totalLiquidadoUSD = 0;
        if (datosJornada.liquidaciones && datosJornada.liquidaciones.length > 0) {
            datosJornada.liquidaciones.forEach(l => {
                totalLiquidadoUSD += parseFloat(l.monto_usd);
                liquidacionesContainer.innerHTML += `<div class="resumen-linea"><span>${l.metodo_pago} <small class="text-white-50">(${l.referencia || 'Sin ref.'})</small></span><div><strong>$${parseFloat(l.monto_usd).toFixed(2)}</strong><button class="btn btn-sm btn-outline-light ms-2 btn-editar-liquidacion" data-id="${l.id}" data-metodo="${l.metodo_pago}" data-monto="${l.monto_usd}" data-referencia="${l.referencia || ''}"><i class="fa-solid fa-pencil"></i></button><button class="btn btn-sm btn-outline-danger" onclick="eliminarLiquidacion(${l.id})"><i class="fa-solid fa-trash"></i></button></div></div>`;
            });
        } else {
            liquidacionesContainer.innerHTML = '<p class="text-center text-white-50">No hay liquidaciones registradas.</p>';
        }
        liquidacionesContainer.innerHTML += `<div class="resumen-linea resumen-total"><span>TOTAL LIQUIDADO:</span> <span data-total-liquidado="${totalLiquidadoUSD.toFixed(2)}">$${totalLiquidadoUSD.toFixed(2)}</span></div>`;
        calcularSaldoFinal();
    }

    function calcularSaldoFinal() {
        const totalIngresosEl = document.querySelector('[data-total-ingresos]');
        const totalGastosEl = document.querySelector('[data-total-gastos]');
        const totalLiquidadoEl = document.querySelector('[data-total-liquidado]');
        const saldoAnterior = parseFloat(datosJornada.saldo_brigada_anterior) || 0;
        const baseInicial = parseFloat(baseInicialInput.value) || 0;
        const totalIngresosUSD = totalIngresosEl ? parseFloat(totalIngresosEl.dataset.totalIngresos) : 0;
        const totalGastosUSD = totalGastosEl ? parseFloat(totalGastosEl.dataset.totalGastos) : 0;
        const totalLiquidadoUSD = totalLiquidadoEl ? parseFloat(totalLiquidadoEl.dataset.totalLiquidado) : 0;
        
        const totalJustificar = (saldoAnterior + baseInicial + totalIngresosUSD) - totalGastosUSD;
        const saldoFinal = totalJustificar - totalLiquidadoUSD;
        
        saldoAnteriorSpan.textContent = `$${saldoAnterior.toFixed(2)}`;
        resumenBaseSpan.textContent = `$${baseInicial.toFixed(2)}`;
        resumenIngresosSpan.textContent = `+$${totalIngresosUSD.toFixed(2)}`;
        resumenGastosSpan.textContent = `-$${totalGastosUSD.toFixed(2)}`;
        totalAJustificarSpan.textContent = `$${totalJustificar.toFixed(2)}`;
        resumenLiquidadoSpan.textContent = `-$${totalLiquidadoUSD.toFixed(2)}`;
        saldoNuevoSpan.textContent = `$${saldoFinal.toFixed(2)}`;
        saldoNuevoSpan.className = saldoFinal >= -0.01 ? 'positivo' : 'negativo';
    }

    // --- MANEJO DE MODALES (Corregido con delegación de eventos) ---
    document.addEventListener('click', function(e) {
        const btnEditarGasto = e.target.closest('.btn-editar-gasto');
        if (btnEditarGasto) {
            const gasto = btnEditarGasto.dataset;
            document.getElementById('formGasto').reset();
            document.getElementById('gasto_id').value = gasto.id;
            document.getElementById('gasto-concepto').value = gasto.concepto;
            document.getElementById('gasto-monto').value = gasto.monto;
            document.getElementById('gasto-moneda').value = gasto.moneda;
            document.getElementById('gasto-descripcion').value = gasto.descripcion;
            modalGasto.show();
        }
        const btnEditarLiquidacion = e.target.closest('.btn-editar-liquidacion');
        if (btnEditarLiquidacion) {
            const liq = btnEditarLiquidacion.dataset;
            document.getElementById('formLiquidacion').reset();
            document.getElementById('liquidacion_id').value = liq.id;
            document.getElementById('liquidacion-metodo').value = liq.metodo;
            document.getElementById('liquidacion-monto').value = liq.monto;
            document.getElementById('liquidacion-referencia').value = liq.referencia;
            modalLiquidacion.show();
        }
    });

    document.getElementById('btn-agregar-gasto').addEventListener('click', () => { document.getElementById('formGasto').reset(); document.getElementById('gasto_id').value = ''; modalGasto.show(); });
    document.getElementById('btn-agregar-liquidacion').addEventListener('click', () => { document.getElementById('formLiquidacion').reset(); document.getElementById('liquidacion_id').value = ''; modalLiquidacion.show(); });
    
    document.getElementById('btnGuardarGasto').addEventListener('click', function() {
        const formData = new FormData();
        formData.append('action', 'guardar_gasto'); formData.append('csrf_token', csrfToken);
        formData.append('jornada_id', selectJornada.value); formData.append('gasto_id', document.getElementById('gasto_id').value);
        formData.append('concepto', document.getElementById('gasto-concepto').value); formData.append('monto', document.getElementById('gasto-monto').value);
        formData.append('moneda', document.getElementById('gasto-moneda').value); formData.append('descripcion', document.getElementById('gasto-descripcion').value);
        fetch('/api/cuadre_ajax.php', { method: 'POST', body: formData }).then(res => res.json()).then(data => {
            if (data.success) { modalGasto.hide(); Swal.fire({ toast: true, position: 'top-end', icon: 'success', title: data.message, showConfirmButton: false, timer: 2000 }); selectJornada.dispatchEvent(new Event('change')); } else { Swal.fire('Error', data.message, 'error'); }
        });
    });

    window.eliminarGasto = function(gastoId) {
        Swal.fire({ title: '¿Confirmar eliminación?', text: "Este gasto se eliminará permanentemente.", icon: 'warning', showCancelButton: true, confirmButtonText: 'Sí, eliminar', cancelButtonText: 'Cancelar'
        }).then(result => {
            if(result.isConfirmed) {
                const formData = new FormData(); formData.append('action', 'eliminar_gasto'); formData.append('gasto_id', gastoId); formData.append('csrf_token', csrfToken);
                fetch('/api/cuadre_ajax.php', { method: 'POST', body: formData }).then(res => res.json()).then(data => {
                    if (data.success) { Swal.fire('Eliminado', data.message, 'success'); selectJornada.dispatchEvent(new Event('change')); } else { Swal.fire('Error', data.message, 'error'); }
                });
            }
        });
    }

    document.getElementById('btnGuardarLiquidacion').addEventListener('click', function() {
        const formData = new FormData();
        formData.append('action', 'guardar_liquidacion'); formData.append('csrf_token', csrfToken);
        formData.append('jornada_id', selectJornada.value); formData.append('liquidacion_id', document.getElementById('liquidacion_id').value);
        formData.append('metodo_pago', document.getElementById('liquidacion-metodo').value);
        formData.append('monto_usd', document.getElementById('liquidacion-monto').value);
        formData.append('referencia', document.getElementById('liquidacion-referencia').value);
        fetch('/api/cuadre_ajax.php', { method: 'POST', body: formData }).then(res => res.json()).then(data => {
            if (data.success) { modalLiquidacion.hide(); Swal.fire({ toast: true, position: 'top-end', icon: 'success', title: data.message, showConfirmButton: false, timer: 2000 }); selectJornada.dispatchEvent(new Event('change')); } else { Swal.fire('Error', data.message, 'error'); }
        });
    });

    window.eliminarLiquidacion = function(liquidacionId) {
        Swal.fire({ title: '¿Confirmar eliminación?', text: "Esta liquidación se eliminará permanentemente.", icon: 'warning', showCancelButton: true, confirmButtonText: 'Sí, eliminar', cancelButtonText: 'Cancelar'
        }).then(result => {
            if(result.isConfirmed) {
                const formData = new FormData(); formData.append('action', 'eliminar_liquidacion'); formData.append('liquidacion_id', liquidacionId); formData.append('csrf_token', csrfToken);
                fetch('/api/cuadre_ajax.php', { method: 'POST', body: formData }).then(res => res.json()).then(data => {
                    if (data.success) { Swal.fire('Eliminada', data.message, 'success'); selectJornada.dispatchEvent(new Event('change')); } else { Swal.fire('Error', data.message, 'error'); }
                });
            }
        });
    }

    document.getElementById('btn-cerrar-caja').addEventListener('click', function() {
        const tasas = getTasas();
        if (!tasas) { Swal.fire('Atención', 'Por favor, ingrese las tasas de cambio del día.', 'warning'); return; }
        const saldoFinal = parseFloat(saldoNuevoSpan.textContent.replace('$', ''));

        const cuadreData = {
            jornada_id: selectJornada.value, tasa_bs: tasas.bs, tasa_cop: tasas.cop,
            base_inicial: parseFloat(baseInicialInput.value) || 0,
            saldo_brigada_anterior: parseFloat(datosJornada.saldo_brigada_anterior) || 0,
            total_ingresos_usd: parseFloat(document.querySelector('[data-total-ingresos]').dataset.totalIngresos),
            total_medicamentos_usd: parseFloat(document.querySelector('[data-total-medicamentos]').dataset.totalMedicamentos),
            total_gastos_usd: parseFloat(document.querySelector('[data-total-gastos]').dataset.totalGastos),
            total_liquidado_usd: parseFloat(document.querySelector('[data-total-liquidado]').dataset.totalLiquidado),
            neto_saldo_final_usd: saldoFinal,
            notas: document.getElementById('notas-cuadre').value
        };

        Swal.fire({
            title: '¿Confirmar Cierre de Jornada?',
            html: `El <b>Nuevo Saldo de Brigada</b> será de <b>$${cuadreData.neto_saldo_final_usd.toFixed(2)}</b>.<br><br>Esta acción es irreversible.`,
            icon: 'warning', showCancelButton: true, confirmButtonText: 'Sí, cerrar y guardar', cancelButtonText: 'Cancelar'
        }).then(result => {
            if(result.isConfirmed) {
                const formData = new FormData(); formData.append('action', 'guardar_cuadre_final'); formData.append('csrf_token', csrfToken); formData.append('cuadre_data', JSON.stringify(cuadreData));
                fetch('/api/cuadre_ajax.php', { method: 'POST', body: formData }).then(res => res.json()).then(data => {
                    if (data.success) { Swal.fire('¡Éxito!', data.message, 'success').then(() => { location.reload(); });
                    } else { Swal.fire('Error', data.message, 'error'); }
                });
            }
        });
    });

    cargarRutas();
});
</script>

<?php include_once 'templates/footer.php'; ?>