<?php
require_once 'includes/seguridad.php';
$page_title = 'Panel de Agendamiento';
include_once 'templates/header.php';

if (!puede('ver_agendamiento_global')) {
    echo "<main class='ami-content'><div class='info-card'><h1>Acceso Denegado</h1><p>No tienes los permisos necesarios para ver este módulo.</p></div></main>";
    include_once 'templates/footer.php';
    exit();
}
?>

<style>
/* Estilos para el Acordeón */
.accordion-item {
    background-color: transparent;
    border: 1px solid var(--border-color);
    border-radius: 10px !important; /* !important para sobreescribir Bootstrap */
    margin-bottom: 1rem;
    overflow: hidden; /* Para que el borde redondeado se aplique bien */
}
.accordion-header {
    border-radius: 10px !important;
}
.accordion-button {
    background: rgba(0,0,0,0.2);
    color: var(--light-text);
    font-weight: 500;
    font-size: 1.2rem;
    border-radius: 10px !important;
}
.accordion-button:not(.collapsed) {
    background-color: var(--primary-color);
    color: var(--dark-text);
    box-shadow: none;
}
.accordion-button:focus {
    box-shadow: none;
    border-color: var(--primary-color);
}
.accordion-button::after { /* Flecha del acordeón */
    filter: invert(1) grayscale(100%) brightness(200%);
}
.accordion-button:not(.collapsed)::after {
    filter: invert(1) grayscale(100%) brightness(0%);
}
.accordion-body {
    padding: 0; /* Quitamos el padding para que la lista ocupe todo */
    background: rgba(0,0,0,0.1);
}
/* Estilos para la lista de jornadas dentro del acordeón */
.jornada-list-group .list-group-item {
    background-color: transparent;
    border: none;
    border-bottom: 1px solid var(--border-color);
    color: var(--light-text);
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1rem 1.5rem;
}
.jornada-list-group .list-group-item:last-child {
    border-bottom: none;
}
.jornada-list-group .list-group-item:hover {
    background-color: rgba(var(--primary-color-rgb), 0.15);
    color: var(--primary-color);
}
.jornada-list-group .jornada-fecha {
    font-weight: 500;
}
</style>

<div class="main-header">
    <h1><?php echo $page_title; ?></h1>
    <p class="text-white-50">Vista de todas las jornadas futuras, agrupadas por ruta/mes.</p>
</div>

<div class="accordion" id="rutas-accordion-container">
    <div class="info-card"><p>Cargando agendamientos...</p></div>
</div>

<?php include_once 'templates/footer.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {

    const container = document.getElementById('rutas-accordion-container');

    function cargarDashboard() {
        container.innerHTML = '<div class="info-card"><p>Cargando agendamientos...</p></div>';

        fetch('/api/agendamiento_ajax.php?action=get_dashboard_por_ruta')
            .then(response => response.ok ? response.json() : Promise.reject('Error de red'))
            .then(data => {
                if (!data.success) throw new Error(data.message);
                
                container.innerHTML = ''; // Limpiar

                if (!data.data || data.data.length === 0) {
                    container.innerHTML = '<div class="info-card"><p>No hay rutas activas con jornadas futuras para mostrar.</p></div>';
                    return;
                }

                data.data.forEach((ruta, index) => {
                    let jornadasHtml = '<div class="list-group-item">Esta ruta no tiene jornadas futuras.</div>';
                    if (ruta.jornadas && ruta.jornadas.length > 0) {
                        jornadasHtml = ruta.jornadas.map(jornada => {
                            const fecha = new Date(jornada.fecha_jornada + 'T00:00:00');
                            const fechaFormateada = fecha.toLocaleDateString('es-ES', { day: '2-digit', month: '2-digit' });
                            
                            return `
                                <a href="agendamiento-detalles.php?id=${jornada.id}" class="list-group-item list-group-item-action">
                                    <div>
                                        <span class="jornada-fecha">${fechaFormateada}</span> - <strong>${jornada.ciudad_nombre}</strong>
                                    </div>
                                    <span class="badge bg-primary rounded-pill">${jornada.total_pacientes} Agendados</span>
                                </a>
                            `;
                        }).join('');
                    }

                    const accordionItemHtml = `
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="heading-${ruta.ruta_id}">
                                <button class="accordion-button ${index === 0 ? '' : 'collapsed'}" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-${ruta.ruta_id}">
                                    ${ruta.nombre_ruta}
                                    <span class="badge bg-secondary ms-3">${ruta.jornadas.length} Jornadas</span>
                                </button>
                            </h2>
                            <div id="collapse-${ruta.ruta_id}" class="accordion-collapse collapse ${index === 0 ? 'show' : ''}" data-bs-parent="#rutas-accordion-container">
                                <div class="accordion-body">
                                    <div class="list-group jornada-list-group">
                                        ${jornadasHtml}
                                    </div>
                                </div>
                            </div>
                        </div>
                    `;
                    container.innerHTML += accordionItemHtml;
                });
            })
            .catch(error => {
                container.innerHTML = `<div class="info-card text-danger"><strong>Error:</strong> ${error.message}</div>`;
                console.error('Error al cargar el dashboard:', error);
            });
    }

    cargarDashboard();
});
</script>