<?php
require_once 'includes/seguridad.php';
$page_title = 'Gestión y Supervisión de Afiliaciones';
include_once 'templates/header.php';

if (!puede('gestionar_afiliaciones_admin')) {
    echo "<main class='ami-content'><div class='info-card'><h1>Acceso Denegado</h1></div></main>";
    include_once 'templates/footer.php';
    exit();
}
?>
<style>
    .nav-tabs .nav-link { color: var(--light-text); }
    .nav-tabs .nav-link.active { color: var(--dark-text); background-color: var(--primary-color); border-color: var(--primary-color); }
    .stat-card { background: var(--card-bg); padding: 1.5rem; border-radius: 12px; text-align: center; height: 100%; display: flex; flex-direction: column; justify-content: center; }
    .stat-card .stat-value { font-size: 2.5rem; font-weight: 700; color: var(--primary-color); }
    .stat-card .stat-label { font-size: 1rem; opacity: 0.8; }
    .info-card h4 { color: var(--primary-color); border-bottom: 1px solid var(--border-color); padding-bottom: 0.5rem; margin-bottom: 1rem; }
    .profile-pic-table { width: 40px; height: 40px; border-radius: 50%; object-fit: cover; }
    .status-dot { height: 10px; width: 10px; border-radius: 50%; display: inline-block; margin-right: 8px; }
    .status-dot.online { background-color: #28a745; box-shadow: 0 0 8px #28a745; animation: pulse 2s infinite; }
    .status-dot.offline { background-color: #6c757d; }
    .progress { height: 8px; background-color: rgba(255,255,255,0.1); border-radius: 5px; }
    .progress-bar { border-radius: 5px; background-color: var(--primary-color); }
    @keyframes pulse { 0% { box-shadow: 0 0 0 0 rgba(40, 167, 69, 0.7); } 70% { box-shadow: 0 0 0 10px rgba(40, 167, 69, 0); } 100% { box-shadow: 0 0 0 0 rgba(40, 167, 69, 0); } }
    #feed-container { max-height: 60vh; overflow-y: auto; }
    .feed-item { border-bottom: 1px solid var(--border-color); padding: 10px 5px; }
    .feed-item:last-child { border-bottom: none; }
    .feed-item p { margin-bottom: 0.25rem; }
    
    /* Mejoras para gráficas */
    .chart-container { 
        background: var(--card-bg); 
        border-radius: 12px; 
        padding: 1.5rem; 
        height: 300px; 
        position: relative;
    }
    .chart-title { 
        color: var(--primary-color); 
        font-size: 1.1rem; 
        font-weight: 600; 
        margin-bottom: 1rem; 
        text-align: center; 
    }
    .analytics-grid { 
        display: grid; 
        grid-template-columns: 1fr 1fr; 
        gap: 2rem; 
        margin-top: 2rem; 
    }
    .ranking-section { 
        grid-column: 1 / -1; 
        display: grid; 
        grid-template-columns: 2fr 1fr; 
        gap: 2rem; 
    }
    @media (max-width: 768px) {
        .analytics-grid { grid-template-columns: 1fr; }
        .ranking-section { grid-template-columns: 1fr; }
    }
    
    /* Estilos para la modal de repetidos */
    .modal-repetidos .modal-content {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
    }
    .modal-repetidos .modal-header {
        border-bottom: 1px solid var(--border-color);
    }
    .modal-repetidos .modal-title {
        color: var(--primary-color);
    }
    .repetidos-table {
        background: rgba(0,0,0,0.2);
        border-radius: 8px;
        overflow: hidden;
    }
    .repetidos-table th {
        background: rgba(120, 227, 32, 0.1);
        color: var(--primary-color);
    }
    .repetidos-table td, .repetidos-table th {
        border-color: var(--border-color);
    }
    .repetidos-count {
        background: #dc3545;
        color: white;
        padding: 2px 8px;
        border-radius: 12px;
        font-size: 0.9rem;
        font-weight: bold;
    }
</style>

<div class="main-header">
    <h1><?php echo $page_title; ?></h1>
</div>

<div class="info-card">
    <ul class="nav nav-tabs" id="adminAfiliacionesTab" role="tablist">
        <li class="nav-item" role="presentation"><button class="nav-link active" id="monitor-tab" data-bs-toggle="tab" data-bs-target="#monitor-panel" type="button" role="tab"><i class="fa-solid fa-satellite-dish me-2"></i>Monitor de Equipo</button></li>
        <li class="nav-item" role="presentation"><button class="nav-link" id="gestion-tab" data-bs-toggle="tab" data-bs-target="#gestion-panel" type="button" role="tab"><i class="fa-solid fa-list-check me-2"></i>Gestión y Asignaciones</button></li>
        <li class="nav-item" role="presentation"><button class="nav-link" id="reportes-tab" data-bs-toggle="tab" data-bs-target="#reportes-panel" type="button" role="tab"><i class="fa-solid fa-street-view me-2"></i>Reportes Operativos</button></li>
        <li class="nav-item" role="presentation"><button class="nav-link" id="analiticas-tab" data-bs-toggle="tab" data-bs-target="#analiticas-panel" type="button" role="tab"><i class="fa-solid fa-chart-line me-2"></i>Analíticas de Rendimiento</button></li>
    </ul>

    <div class="tab-content pt-4">
        <div class="tab-pane fade show active" id="monitor-panel" role="tabpanel">
            <h4><i class="fa-solid fa-satellite-dish"></i> Monitor en Tiempo Real</h4>
            <div class="table-responsive"><table class="ami-table"><thead><tr><th>Asesor</th><th>Estado</th><th>Asignados</th><th>Gestionados</th><th>Rendimiento (Hoy)</th><th>Última Acción</th><th></th></tr></thead><tbody id="monitorEquipoBody"></tbody></table></div>
        </div>
        <div class="tab-pane fade" id="gestion-panel" role="tabpanel">
             <div class="row"><div class="col-lg-4"><div class="stat-card"><div id="piscina-count" class="stat-value">...</div><div class="stat-label">Contactos en Piscina</div></div></div><div class="col-lg-8"><div class="stat-card" style="gap: 1rem;"><div class="row w-100 g-3"><div class="col-md-4"><button class="btn btn-info btn-lg w-100" data-bs-toggle="modal" data-bs-target="#modalAgregarManual"><i class="fa-solid fa-plus"></i> Manual</button></div><div class="col-md-4"><button class="btn btn-primary btn-lg w-100" data-bs-toggle="modal" data-bs-target="#modalImportar"><i class="fa-solid fa-file-csv"></i> Importar</button></div><div class="col-md-4"><button class="btn btn-success btn-lg w-100" data-bs-toggle="modal" data-bs-target="#modalAsignar"><i class="fa-solid fa-share-nodes"></i> Asignar</button></div></div></div></div></div>
            <h4 class="mt-4"><i class="fa-solid fa-history"></i> Historial de Asignaciones Recientes</h4>
            <div class="table-responsive"><table class="ami-table"><thead><tr><th>Operador</th><th class="text-center">Cantidad</th><th>Fecha</th><th>Asignado Por</th><th>Acciones</th></tr></thead><tbody id="tablaAsignaciones"></tbody></table></div>
        </div>
        <div class="tab-pane fade" id="reportes-panel" role="tabpanel">
            <h4><i class="fa-solid fa-street-view"></i> Reporte de Contactos PaP (Puerta a Puerta)</h4>
            <div class="table-responsive"><table class="ami-table"><thead><tr><th>Operador</th><th class="text-center">Total PaP</th><th>Acciones</th></tr></thead><tbody id="tablaReportePap"></tbody></table></div>
        </div>
        <div class="tab-pane fade" id="analiticas-panel" role="tabpanel">
            <h4><i class="fa-solid fa-chart-line"></i> Analíticas de Rendimiento</h4>
            
            <div class="ranking-section">
                <div class="chart-container">
                    <div class="chart-title"><i class="fa-solid fa-ranking-star"></i> Ranking de Operadores</div>
                    <div class="table-responsive" style="max-height: 220px; overflow-y: auto;">
                        <table class="ami-table"><thead><tr><th>#</th><th>Operador</th><th>Gestionados</th><th>Afiliados</th><th>Tasa</th></tr></thead><tbody id="rankingBody"></tbody></table>
                    </div>
                </div>
                <div class="chart-container">
                    <div class="chart-title">Top 5 Afiliadores</div>
                    <canvas id="graficoRanking" style="max-height: 220px;"></canvas>
                </div>
            </div>

            <div class="analytics-grid">
                <div class="chart-container">
                    <div class="chart-title">Volumen por Origen</div>
                    <canvas id="graficoOrigenVolumen" style="max-height: 220px;"></canvas>
                </div>
                <div class="chart-container">
                    <div class="chart-title">Efectividad por Origen</div>
                    <canvas id="graficoOrigenEfectividad" style="max-height: 220px;"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modales existentes -->
<div class="modal fade ami-modal-theme" id="modalAgregarManual" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><div class="modal-header"><h5 class="modal-title">Agregar Contacto Manualmente</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body"><form id="formAgregarManual"><div class="ami-form-group mb-3"><label class="ami-form-label">Nombre Completo</label><input type="text" name="nombre" class="form-control"></div><div class="ami-form-group mb-3"><label class="ami-form-label">Teléfono</label><input type="text" name="telefono" class="form-control" required></div><div class="ami-form-group mb-3"><label class="ami-form-label">Campaña</label><input type="text" name="campana" class="form-control"></div><div class="ami-form-group"><label class="ami-form-label">Origen</label><select name="origen" class="form-select"><option value="">-- Seleccionar --</option><option value="Facebook">Facebook</option><option value="Instagram">Instagram</option><option value="WhatsApp">WhatsApp</option><option value="Referido">Referido</option><option value="Punto Físico">Punto Físico</option><option value="Otro">Otro</option></select></div></form></div><div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="button" class="btn btn-primary" id="btnConfirmarAgregarManual">Guardar</button></div></div></div></div>
<div class="modal fade ami-modal-theme" id="modalImportar" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><div class="modal-header"><h5 class="modal-title">Importar Contactos a la Piscina</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body"><form id="formImportar" enctype="multipart/form-data"><p class="text-white-50 small">El archivo CSV debe tener 5 columnas: <strong>nombre, telefono, campana, zona, origen</strong>.</p><div class="ami-form-group"><label class="ami-form-label">Archivo .csv</label><input type="file" class="form-control" name="archivo_csv" accept=".csv" required></div></form></div><div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="button" class="btn btn-primary" id="btnConfirmarImportar">Cargar</button></div></div></div></div>
<div class="modal fade ami-modal-theme" id="modalAsignar" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><div class="modal-header"><h5 class="modal-title">Asignar Lote de Contactos</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body"><form id="formAsignar"><div class="ami-form-group mb-3"><label class="ami-form-label">Asignar a Operador</label><select name="operador_id" id="selectOperadorAsignar" class="form-select" required></select></div><div class="ami-form-group"><label class="ami-form-label">Cantidad</label><input type="number" class="form-control" name="cantidad" placeholder="Ej: 50" min="1" required></div></form></div><div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="button" class="btn btn-primary" id="btnConfirmarAsignar">Confirmar</button></div></div></div></div>
<div class="modal fade ami-modal-theme" id="modalLoteDetalle" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><div class="modal-header"><h5 class="modal-title">Contactos Asignados en Lote</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body"><div class="table-responsive"><table class="ami-table"><thead><tr><th>Nombre</th><th>Teléfono</th></tr></thead><tbody id="lote-detalle-body"></tbody></table></div></div><div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div></div></div></div>
<div class="modal fade ami-modal-theme" id="modalReportePapDetalle" tabindex="-1"><div class="modal-dialog modal-xl"><div class="modal-content"><div class="modal-header"><h5 class="modal-title">Detalle PaP de <span id="pap-operador-nombre" class="text-primary"></span></h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body"><div class="table-responsive"><table class="ami-table"><thead><tr><th>Nombre</th><th>Teléfono</th><th>Estado</th><th>Último Contacto</th><th>Observaciones</th></tr></thead><tbody id="pap-detalle-body"></tbody></table></div></div><div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div></div></div></div>
<div class="modal fade ami-modal-theme" id="modalLiveFeed" tabindex="-1"><div class="modal-dialog modal-lg"><div class="modal-content"><div class="modal-header"><h5 class="modal-title">Actividad en Vivo de <span id="live-feed-operador-nombre" class="text-primary"></span></h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body"><div id="feed-container"></div></div><div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div></div></div></div>

<!-- Nueva Modal para Contactos Repetidos -->
<div class="modal fade modal-repetidos" id="modalRepetidos" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fa-solid fa-triangle-exclamation text-warning me-2"></i>Contactos Ya Existentes</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning">
                    <p class="mb-0"><strong id="repetidos-message"></strong></p>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped table-bordered repetidos-table">
                        <thead>
                            <tr>
                                <th>Nombre</th>
                                <th>Teléfono</th>
                            </tr>
                        </thead>
                        <tbody id="repetidos-body">
                            <!-- Se llenará dinámicamente -->
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-bs-dismiss="modal">Aceptar</button>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const csrfToken = '<?php echo $_SESSION['csrf_token']; ?>';
    const modales = {
        importar: new bootstrap.Modal(document.getElementById('modalImportar')),
        asignar: new bootstrap.Modal(document.getElementById('modalAsignar')),
        manual: new bootstrap.Modal(document.getElementById('modalAgregarManual')),
        reportePap: new bootstrap.Modal(document.getElementById('modalReportePapDetalle')),
        liveFeed: new bootstrap.Modal(document.getElementById('modalLiveFeed')),
        loteDetalle: new bootstrap.Modal(document.getElementById('modalLoteDetalle')),
        repetidos: new bootstrap.Modal(document.getElementById('modalRepetidos')) // Nueva modal
    };
    let monitorInterval, liveFeedInterval;
    let charts = {};

    // Variable para el formulario de agregar manual
    const formAgregarManual = document.getElementById('formAgregarManual');

    // Función para limpiar el formulario de agregar manual
    function limpiarFormularioManual() {
        formAgregarManual.reset();
        // Opcional: puedes establecer valores por defecto específicos si los necesitas
        // formAgregarManual.querySelector('[name="origen"]').value = ""; // Ejemplo
    }

    function timeAgo(dateString) {
        if (!dateString) return 'Nunca';
        const date = new Date(dateString.replace(' ', 'T'));
        const seconds = Math.floor((new Date() - date) / 1000);
        let interval = seconds / 31536000; if (interval > 1) return `hace ${Math.floor(interval)} años`;
        interval = seconds / 2592000; if (interval > 1) return `hace ${Math.floor(interval)} meses`;
        interval = seconds / 86400; if (interval > 1) return `hace ${Math.floor(interval)} días`;
        interval = seconds / 3600; if (interval > 1) return `hace ${Math.floor(interval)} horas`;
        interval = seconds / 60; if (interval > 1) return `hace ${Math.floor(interval)} minutos`;
        return `hace unos segundos`;
    }

    function cargarDatosGestion() {
        fetch('/api/afiliaciones_gestion_ajax.php?action=cargar_dashboard_admin').then(res => res.json()).then(data => {
            if (!data.success) { Swal.fire('Error', data.message, 'error'); return; }
            const d = data.data;
            document.getElementById('piscina-count').textContent = d.piscina_count || 0;
            const selectOperador = document.getElementById('selectOperadorAsignar');
            selectOperador.innerHTML = '<option value="">Seleccione un operador</option>';
            d.operadores.forEach(op => { selectOperador.innerHTML += `<option value="${op.id}">${op.nombre}</option>`; });
            const tablaLotesBody = document.getElementById('tablaAsignaciones');
            tablaLotesBody.innerHTML = '';
            if (d.lotes && d.lotes.length > 0) {
                tablaLotesBody.innerHTML = d.lotes.map(lote => `<tr><td>${lote.operador_nombre}</td><td class="text-center">${lote.cantidad}</td><td>${new Date(lote.fecha_asignacion).toLocaleString('es-ES')}</td><td>${lote.admin_nombre || 'Sistema'}</td><td><button class="btn btn-sm btn-outline-info" onclick="verDetalleLote('${lote.lote_id}')" title="Ver Contactos del Lote"><i class="fa-solid fa-eye"></i></button></td></tr>`).join('');
            } else { tablaLotesBody.innerHTML = '<tr><td colspan="5" class="text-center">No hay asignaciones recientes.</td></tr>'; }
        });
    }

    function cargarMonitorEquipo() {
        const monitorBody = document.getElementById('monitorEquipoBody');
        fetch('/api/afiliaciones_gestion_ajax.php?action=cargar_monitor_equipo').then(res => res.json()).then(data => {
            if (data.success) {
                if (data.data.length === 0) { monitorBody.innerHTML = '<tr><td colspan="7" class="text-center">No hay operadores en tu equipo.</td></tr>'; return; }
                monitorBody.innerHTML = data.data.map(op => {
                    const fotoSrc = op.foto_perfil ? `/uploads/perfiles/${op.foto_perfil}` : '/uploads/perfiles/default.png';
                    const progreso = op.total_asignado > 0 ? Math.round((op.gestionados / op.total_asignado) * 100) : 0;
                    return `<tr><td><div class="d-flex align-items-center gap-2"><img src="${fotoSrc}" class="profile-pic-table"><strong>${op.nombre}</strong></div></td><td><span class="status-dot ${op.estado_actual.toLowerCase()}"></span> ${op.estado_actual}</td><td class="text-center">${op.total_asignado}</td><td><span>${op.gestionados} (${progreso}%)</span><div class="progress mt-1"><div class="progress-bar" style="width: ${progreso}%;"></div></div></td><td class="text-center"><strong>${op.rendimiento_hoy}</strong></td><td><small>${op.ultima_accion_detalle.substring(0,70)}...<br><span class="text-white-50">${timeAgo(op.ultima_accion_fecha)}</span></small></td><td><button class="btn btn-sm btn-outline-light" onclick='verActividadEnVivo(${op.id}, "${op.nombre.replace(/"/g, '\\"')}")'>Ver en Vivo</button></td></tr>`;
                }).join('');
            }
        });
    }

    function cargarDatosReportes() {
        const reportePapBody = document.getElementById('tablaReportePap');
        fetch('/api/afiliaciones_gestion_ajax.php?action=cargar_reporte_pap').then(res => res.json()).then(data => {
            if (data.success) {
                reportePapBody.innerHTML = data.data.length > 0 ? data.data.map(r => `<tr><td>${r.operador_nombre}</td><td class="text-center"><strong>${r.total_pap}</strong></td><td><button class="btn btn-sm btn-outline-info" onclick='verDetallePap(${r.operador_id}, "${r.operador_nombre.replace(/'/g, "\\'")}")'><i class="fa-solid fa-list-ul"></i> Ver Detalle</button></td></tr>`).join('') : '<tr><td colspan="3" class="text-center">No hay contactos PaP.</td></tr>';
            }
        });
        fetch('/api/afiliaciones_gestion_ajax.php?action=get_analiticas').then(res => res.json()).then(data => {
            if (data.success) {
                renderizarRanking(data.data.ranking);
                renderizarGrafico('graficoRanking', 'bar', data.data.ranking.slice(0,5).map(r => r.nombre), data.data.ranking.slice(0,5).map(r => r.total_afiliados), 'Total Afiliados');
                renderizarGrafico('graficoOrigenVolumen', 'doughnut', data.data.origen_volumen.map(o => o.origen), data.data.origen_volumen.map(o => o.total), 'Volumen por Origen');
                renderizarGrafico('graficoOrigenEfectividad', 'bar', data.data.origen_efectividad.map(o => o.origen), data.data.origen_efectividad.map(o => o.tasa_cierre), 'Tasa de Cierre (%)');
            }
        });
    }

    function renderizarRanking(ranking) {
        const rankingBody = document.getElementById('rankingBody');
        if (ranking.length > 0) {
            rankingBody.innerHTML = ranking.map((r, index) => {
                const tasaCierre = r.total_gestionados > 0 ? ((r.total_afiliados / r.total_gestionados) * 100).toFixed(1) : 0;
                return `<tr><td>${index + 1}</td><td><div class="d-flex align-items-center gap-2"><img src="${r.foto_perfil ? '/uploads/perfiles/'+r.foto_perfil : '/uploads/perfiles/default.png'}" class="profile-pic-table"><strong>${r.nombre}</strong></div></td><td>${r.total_gestionados}</td><td>${r.total_afiliados}</td><td><strong>${tasaCierre}%</strong></td></tr>`;
            }).join('');
        } else { rankingBody.innerHTML = '<tr><td colspan="5" class="text-center">No hay datos de rendimiento.</td></tr>'; }
    }

    function renderizarGrafico(canvasId, tipo, labels, data, label) {
        const ctx = document.getElementById(canvasId).getContext('2d');
        if (charts[canvasId]) charts[canvasId].destroy();
        
        const colores = ['#78E320', '#1F77B4', '#FF7F0E', '#2CA02C', '#D62728', '#9467BD', '#8C564B', '#E377C2'];
        
        const config = {
            type: tipo,
            data: {
                labels: labels,
                datasets: [{
                    label: label,
                    data: data,
                    backgroundColor: colores,
                    borderColor: colores.map(c => c + '80'),
                    borderWidth: 2
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: tipo === 'doughnut' ? 'right' : 'top',
                        labels: { 
                            color: '#fff',
                            boxWidth: 12,
                            padding: 10
                        }
                    }
                },
                scales: tipo === 'doughnut' ? {} : {
                    y: { 
                        ticks: { color: '#fff' },
                        grid: { color: 'rgba(255,255,255,0.1)' }
                    },
                    x: { 
                        ticks: { color: '#fff' },
                        grid: { color: 'rgba(255,255,255,0.1)' }
                    }
                }
            }
        };
        
        charts[canvasId] = new Chart(ctx, config);
    }

    // Función para mostrar la modal de repetidos
    function mostrarModalRepetidos(message, repetidos) {
        document.getElementById('repetidos-message').textContent = message;
        const repetidosBody = document.getElementById('repetidos-body');
        
        // Limpiar contenido anterior
        repetidosBody.innerHTML = '';
        
        // Agregar cada contacto repetido
        repetidos.forEach(contacto => {
            const row = document.createElement('tr');
            row.innerHTML = `
                <td>${contacto.nombre}</td>
                <td>${contacto.telefono}</td>
            `;
            repetidosBody.appendChild(row);
        });
        
        // Mostrar la modal
        modales.repetidos.show();
    }

    window.verActividadEnVivo = function(operadorId, operadorNombre) {
        document.getElementById('live-feed-operador-nombre').textContent = operadorNombre;
        const feedContainer = document.getElementById('feed-container');
        function cargarFeed() {
            fetch(`/api/afiliaciones_gestion_ajax.php?action=get_operador_live_feed&operador_id=${operadorId}`).then(res => res.json()).then(data => {
                if (data.success && data.data.length > 0) { feedContainer.innerHTML = data.data.map(item => `<div class="feed-item"><small class="text-white-50">${timeAgo(item.fecha)}</small><p class="mb-0">${item.detalle}</p></div>`).join(''); } 
                else { feedContainer.innerHTML = '<p class="text-center text-white-50">Sin actividad reciente.</p>'; }
            });
        }
        cargarFeed();
        liveFeedInterval = setInterval(cargarFeed, 10000);
        modales.liveFeed.show();
    };

    window.verDetalleLote = function(loteId) {
        const detalleBody = document.getElementById('lote-detalle-body');
        detalleBody.innerHTML = '<tr><td colspan="2" class="text-center">Cargando...</td></tr>';
        modales.loteDetalle.show();
        fetch(`/api/afiliaciones_gestion_ajax.php?action=get_lote_detalle&lote_id=${loteId}`).then(res => res.json()).then(data => {
            if(data.success && data.data.length > 0) { detalleBody.innerHTML = data.data.map(d => `<tr><td>${d.nombre}</td><td>${d.telefono}</td></tr>`).join(''); } 
            else { detalleBody.innerHTML = '<tr><td colspan="2" class="text-center">No se encontraron detalles.</td></tr>'; }
        });
    };
    
    window.verDetallePap = function(operadorId, operadorNombre) {
        document.getElementById('pap-operador-nombre').textContent = operadorNombre;
        const detalleBody = document.getElementById('pap-detalle-body');
        detalleBody.innerHTML = '<tr><td colspan="5" class="text-center">Cargando...</td></tr>';
        modales.reportePap.show();
        fetch(`/api/afiliaciones_gestion_ajax.php?action=get_reporte_pap_detalle&operador_id=${operadorId}`).then(res => res.json()).then(data => {
            if (data.success && data.data.length > 0) {
                detalleBody.innerHTML = data.data.map(d => `<tr><td>${d.nombre}</td><td>${d.telefono}</td><td>${d.estado}</td><td>${timeAgo(d.fecha_ultimo_contacto)}</td><td><small>${(d.observaciones || '').substring(0, 50)}...</small></td></tr>`).join('');
            } else { detalleBody.innerHTML = '<tr><td colspan="5" class="text-center">No hay detalles.</td></tr>'; }
        });
    }

    document.getElementById('modalLiveFeed').addEventListener('hidden.bs.modal', () => clearInterval(liveFeedInterval));
    
    // Limpiar el formulario cuando se muestra el modal
    document.getElementById('modalAgregarManual').addEventListener('show.bs.modal', function () {
        limpiarFormularioManual();
    });
    
    document.getElementById('btnConfirmarAgregarManual').addEventListener('click', function() {
        // NO usamos checkValidity() para el nombre, solo para teléfono
        const telefonoInput = formAgregarManual.querySelector('[name="telefono"]');
        if (!telefonoInput.value.trim()) { 
            Swal.fire('Atención', 'El teléfono es obligatorio.', 'warning'); 
            return; 
        }
        
        const formData = new FormData(formAgregarManual);
        formData.append('action', 'agregar_manual');
        formData.append('csrf_token', csrfToken);
        modales.manual.hide();
        Swal.fire({ title: 'Guardando...', allowOutsideClick: false, didOpen: () => Swal.showLoading() });
        fetch('/api/afiliaciones_gestion_ajax.php', { method: 'POST', body: formData }).then(res => res.json()).then(data => {
            if (data.success) { 
                Swal.fire('¡Éxito!', data.message, 'success').then(() => { 
                    cargarDatosGestion(); 
                    cargarDatosReportes(); 
                    limpiarFormularioManual(); // Limpiar el formulario después de un éxito
                }); 
            } 
            else { Swal.fire('Error', data.message, 'error'); }
        });
    });

    document.getElementById('btnConfirmarImportar').addEventListener('click', function(){
        const form = document.getElementById('formImportar');
        if (!form.querySelector('input[type=file]').files.length) { 
            Swal.fire('Atención', 'Selecciona un archivo.', 'warning'); 
            return; 
        }
        const formData = new FormData(form);
        formData.append('action', 'importar_a_piscina');
        formData.append('csrf_token', csrfToken);
        modales.importar.hide();
        Swal.fire({ 
            title: 'Procesando...', 
            allowOutsideClick: false, 
            didOpen: () => Swal.showLoading() 
        });
        fetch('/api/afiliaciones_gestion_ajax.php', { 
            method: 'POST', 
            body: formData 
        }).then(res => res.json()).then(data => {
            if (data.success) {
                // Si hay repetidos, mostrar modal personalizada
                if (data.repetidos && data.repetidos.length > 0) {
                    Swal.close(); // Cerrar la alerta de procesando
                    // Mostrar mensaje de éxito con cantidad importada
                    Swal.fire({
                        title: '¡Éxito!',
                        text: `Se importaron ${data.message.match(/\d+/)[0]} contactos a la piscina.`,
                        icon: 'success',
                        timer: 2000,
                        timerProgressBar: true,
                        showConfirmButton: false
                    });
                    
                    // Mostrar modal con contactos repetidos después de un breve retraso
                    setTimeout(() => {
                        mostrarModalRepetidos(
                            `Se encontraron ${data.repetidos.length} contactos que ya existían en la base de datos:`,
                            data.repetidos
                        );
                    }, 2100);
                } else {
                    // No hay repetidos, mostrar mensaje normal
                    Swal.fire('¡Éxito!', data.message, 'success').then(() => {
                        cargarDatosGestion();
                    });
                }
            } else {
                Swal.fire('Error', data.message, 'error');
            }
        });
    });

    document.getElementById('btnConfirmarAsignar').addEventListener('click', function() {
        const form = document.getElementById('formAsignar');
        if (!form.checkValidity()) { Swal.fire('Atención', 'Completa todos los campos.', 'warning'); return; }
        const formData = new FormData(form);
        formData.append('action', 'asignar_a_operador');
        formData.append('csrf_token', csrfToken);
        modales.asignar.hide();
        Swal.fire({ title: 'Asignando...', allowOutsideClick: false, didOpen: () => Swal.showLoading() });
        fetch('/api/afiliaciones_gestion_ajax.php', { method: 'POST', body: formData }).then(res => res.json()).then(data => {
            if (data.success) { Swal.fire('¡Éxito!', data.message, 'success').then(cargarDatosGestion); } 
            else { Swal.fire('Error', data.message, 'error'); }
        });
    });
    
    // Control de Pestañas
    const tabs = document.querySelectorAll('#adminAfiliacionesTab .nav-link');
    tabs.forEach(tab => {
        tab.addEventListener('shown.bs.tab', function(event) {
            clearInterval(monitorInterval);
            const targetTab = event.target.id;
            if (targetTab === 'monitor-tab') { cargarMonitorEquipo(); monitorInterval = setInterval(cargarMonitorEquipo, 15000); }
            if (targetTab === 'gestion-tab') cargarDatosGestion();
            if (targetTab === 'reportes-tab' || targetTab === 'analiticas-tab') cargarDatosReportes();
        });
    });

    // Carga inicial
    cargarMonitorEquipo();
    monitorInterval = setInterval(cargarMonitorEquipo, 15000);
});
</script>

<?php include_once 'templates/footer.php'; ?>